/*
 * Decompiled with CFR 0.152.
 */
package ha2;

import java.awt.geom.Point2D;
import robocode.util.Utils;

public class WaveBullet {
    private double startX;
    private double startY;
    private double startBearing;
    private double power;
    private long fireTime;
    private int direction;
    private int[] returnSegment;

    public WaveBullet(double x, double y, double bearing, double power, int direction, long time, int[] segment) {
        this.startX = x;
        this.startY = y;
        this.startBearing = bearing;
        this.power = power;
        this.direction = direction;
        this.fireTime = time;
        this.returnSegment = segment;
    }

    public double getBulletSpeed() {
        return 20.0 - this.power * 3.0;
    }

    public double maxEscapeAngle() {
        return Math.asin(8.0 / this.getBulletSpeed());
    }

    public boolean checkHit(double enemyX, double enemyY, long currentTime) {
        if (Point2D.distance(this.startX, this.startY, enemyX, enemyY) <= (double)(currentTime - this.fireTime) * this.getBulletSpeed()) {
            int index;
            double desiredDirection = Math.atan2(enemyX - this.startX, enemyY - this.startY);
            double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - this.startBearing));
            double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / this.maxEscapeAngle())) * (double)this.direction;
            int n = index = (int)Math.round((double)((this.returnSegment.length - 1) / 2) * (guessFactor + 1.0));
            this.returnSegment[n] = this.returnSegment[n] + 1;
            return true;
        }
        return false;
    }
}

