/*
 * Decompiled with CFR 0.152.
 */
package pedersen.debug;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import pedersen.misc.Persistence;

public class Debug {
    private PrintStream pringStream = null;
    private List fileDump = new ArrayList();
    public static final Debug singleton = new Debug();

    private Debug() {
    }

    public void setPrintStream(PrintStream newPrintStream) {
        this.pringStream = newPrintStream;
    }

    public void teardown() {
        Persistence.singleton.writeListToFile("debug", Debug.singleton.fileDump);
    }

    public static void line(String line) {
        Debug.singleton.pringStream.println(line);
    }

    public static void debug(String line) {
        Debug.singleton.fileDump.add(String.valueOf(line) + "\n");
    }

    public static void exception(String source, Exception ex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Exception thrown in ").append(source).append(":\n");
        buffer.append(ex.toString()).append("\n");
        buffer.append(ex.getMessage()).append("\n");
        buffer.append(ex.getCause()).append("\n");
        ArrayList<String> localFileDump = new ArrayList<String>();
        localFileDump.add(buffer.toString());
        Persistence.singleton.writeListToFile("exception", localFileDump);
    }

    public static String trim(double value) {
        String untrimmed;
        String trimmed = untrimmed = String.valueOf(value);
        int indexOfDecimal = untrimmed.indexOf(46);
        if (indexOfDecimal > 0 && untrimmed.length() > indexOfDecimal + 2) {
            trimmed = untrimmed.substring(0, indexOfDecimal + 3);
        }
        if (untrimmed.indexOf(101) > 0) {
            trimmed = String.valueOf(trimmed) + untrimmed.substring(untrimmed.indexOf(101));
        }
        return trimmed;
    }
}

