/*
 * Decompiled with CFR 0.152.
 */
package omens;

import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class CannonfodderMicro
extends AdvancedRobot {
    private long prevTime = 0L;
    private double bulletPower;
    int scannedX = Integer.MIN_VALUE;
    int scannedY = Integer.MIN_VALUE;

    public void run() {
        this.setBodyColor(Color.white);
        this.setGunColor(Color.gray);
        this.setBulletColor(Color.red);
        this.setRadarColor(Color.white);
        this.setScanColor(Color.yellow);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.randomMove();
        while (true) {
            this.turnRadarRightRadians(1.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (e.getEnergy() > 3.0) {
            this.bulletPower = Math.min(400.0 / e.getDistance(), 3.0);
            this.linearTargeting(e);
            this.shoot();
            if (this.getTime() % 10L == 0L && this.getTime() - this.prevTime > 10L) {
                this.randomMove();
            }
        } else {
            this.setTurnRightRadians(e.getBearingRadians());
            this.setAhead(e.getDistance());
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.prevTime = this.getTime();
        this.setTurnRight(e.getHeading() + 90.0);
        this.setAhead(100.0);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.prevTime = this.getTime();
        this.setBack(200.0);
    }

    public void onHitWall(HitWallEvent e) {
        this.setTurnRight(e.getBearing() + 180.0);
        this.setAhead(200.0);
    }

    public void onWin(WinEvent e) {
        this.setTurnGunLeft(720.0);
        this.turnRight(720.0);
    }

    public void headOnTargeting(ScannedRobotEvent e) {
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians() - this.getGunHeadingRadians())));
    }

    public void linearTargeting(ScannedRobotEvent e) {
        double myX = this.getX();
        double myY = this.getY();
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyX = this.getX() + e.getDistance() * Math.sin(absoluteBearing);
        double enemyY = this.getY() + e.getDistance() * Math.cos(absoluteBearing);
        double enemyHeading = e.getHeadingRadians();
        double enemyVelocity = e.getVelocity();
        double deltaTime = 0.0;
        double battleFieldHeight = this.getBattleFieldHeight();
        double battleFieldWidth = this.getBattleFieldWidth();
        double predictedX = enemyX;
        double predictedY = enemyY;
        while ((deltaTime += 1.0) * (20.0 - 3.0 * this.bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if (!((predictedX += Math.sin(enemyHeading) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getX(), predictedY - this.getY()));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
    }

    public void shoot() {
        if (this.getGunHeat() == 0.0 && Math.abs(this.getGunTurnRemaining()) < 10.0) {
            this.setFire(this.bulletPower);
        }
    }

    public void chase(ScannedRobotEvent e) {
        if (e.getDistance() > 200.0) {
            this.setTurnRightRadians(e.getBearingRadians());
            this.setAhead(e.getDistance() - 200.0);
        }
    }

    public void randomMove() {
        this.goTo(Math.random() * this.getBattleFieldWidth(), Math.random() * this.getBattleFieldHeight());
    }

    private void goTo(double destinationX, double destinationY) {
        double angle = Utils.normalRelativeAngle((double)(Math.atan2(destinationX -= this.getX(), destinationY -= this.getY()) - this.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this.setTurnRightRadians(turnAngle);
        this.setAhead(Math.hypot(destinationX, destinationY) * (double)(angle == turnAngle ? 1 : -1));
    }
}

