/*
 * Decompiled with CFR 0.152.
 */
package agd.predict;

import agd.predict.AverageCircularPrediction;
import agd.predict.AverageGridPrediction;
import agd.predict.AveragePositionPrediction;
import agd.predict.CircularPrediction;
import agd.predict.DisplacementPrediction;
import agd.predict.Footprint;
import agd.predict.LinearPrediction;
import agd.predict.PrevDeltaPrediction;
import agd.predict.StablePrediction;
import agd.predict.TargetPrediction;
import agd.predict.Trackable;
import agd.util.Compass;
import agd.util.Coord;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public abstract class TargetPrediction {
    public static final TargetPrediction CIRCULAR = new CircularPrediction();
    public static final TargetPrediction LINEAR = new LinearPrediction();
    public static final TargetPrediction STATIONARY = new StablePrediction();
    public static final TargetPrediction AVERAGE_CIRCULAR = new AverageCircularPrediction();
    public static final TargetPrediction PREV_DELTA = new PrevDeltaPrediction();
    public static final TargetPrediction AV_POS25 = new AveragePositionPrediction(25);
    public static final TargetPrediction AV_POS50 = new AveragePositionPrediction(50);
    public static final TargetPrediction AV_POS100 = new AveragePositionPrediction(100);
    public static final TargetPrediction AV_GRID10 = new AverageGridPrediction(10);
    public static final TargetPrediction DISPLACEMENT = new DisplacementPrediction();
    static TargetPrediction[] algorithms = new TargetPrediction[]{CIRCULAR, LINEAR, STATIONARY, AVERAGE_CIRCULAR, PREV_DELTA, AV_GRID10, DISPLACEMENT, new DisplacementPrediction(25), new DisplacementPrediction(50), new DisplacementPrediction(100), new AveragePositionPrediction(10), AV_POS25, AV_POS50, AV_POS100};

    public static TargetPrediction[] getAlgorithms() {
        return algorithms;
    }

    public abstract Coord predictTarget(List var1, long var2);

    public Coord predictTarget(Trackable target, long futureTime) {
        Coord prediction = null;
        try {
            List footprints = target.getRecentFootprints();
            if (footprints == null) {
                System.out.println("Received a null list from target.getRecentFootprints() for target " + target);
            } else if (footprints.size() == 0) {
                System.out.println("Received an empty list from target.getRecentFootprints() for target " + target);
            }
            prediction = this.predictTarget(footprints, futureTime);
        }
        catch (NullPointerException npe) {
            System.out.println(this + " caught exception:\n" + npe + "\nTarget = " + target + ", time=" + futureTime + ", Why are we getting these?\n");
            npe.printStackTrace(System.out);
            prediction = Coord.ORIGIN;
        }
        return prediction;
    }

    public Coord retrospectivelyPredict(Trackable target, long futureTime, long predictionTime) {
        List footprints = this.stripFootprintsAfter(target.getRecentFootprints(), predictionTime);
        if (footprints.size() == 0) {
            return null;
        }
        return this.predictTarget(footprints, futureTime);
    }

    private List stripFootprintsAfter(List fullFootprints, long beforeTime) {
        ListIterator l = fullFootprints.listIterator(0);
        class TimeComparableFootprint
        implements Footprint {
            private long time;
            private final /* synthetic */ TargetPrediction this$0;

            public TimeComparableFootprint(TargetPrediction this$0, long t) {
                this.this$0 = this$0;
                this.time = t;
            }

            public long getTime() {
                return this.time;
            }

            public Compass getHeading() {
                return Compass.NORTH;
            }

            public double getVelocity() {
                return 0.0;
            }

            public double getAcceleration() {
                return 0.0;
            }

            public Coord getPosition() {
                return Coord.ORIGIN;
            }
        }
        TimeComparableFootprint key = new TimeComparableFootprint(this, beforeTime + 1L);
        class FpTimeComparison
        implements Comparator {
            private final /* synthetic */ TargetPrediction this$0;

            FpTimeComparison(TargetPrediction this$0) {
                this.this$0 = this$0;
            }

            public int compare(Object o1, Object o2) {
                return (int)(((Footprint)o1).getTime() - ((Footprint)o2).getTime());
            }
        }
        int index = Collections.binarySearch(fullFootprints, key, new FpTimeComparison(this));
        if (index < 0) {
            index = Math.abs(index + 1);
        }
        return fullFootprints.subList(0, index);
    }
}

