/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.predict.TargetPrediction;
import agd.util.Coord;
import agd.util.Enemy;
import agd.util.RobotSighting;
import agd.util.RollingAverage;
import agd.util.World;
import java.text.MessageFormat;
import robocode.HitByBulletEvent;

public class EnemyStats {
    String name = null;
    int hitUs = 0;
    int hitThem = 0;
    int killedUs = 0;
    int killedThem = 0;
    double damageOnThem = 0.0;
    double damageOnUs = 0.0;
    double damageRatio = 0.0;
    static final int BEST_PREDICTION_RANGE = 120;
    static final int BEST_PREDICTION_PERIODS = 12;
    RollingAverage[][] predictionSuccess = null;
    RollingAverage[][] predictionSuccess1v1 = null;
    RollingAverage ourAccuracy;

    EnemyStats(String name) {
        this.name = name;
        this.predictionSuccess = new RollingAverage[TargetPrediction.getAlgorithms().length][13];
        this.predictionSuccess1v1 = new RollingAverage[TargetPrediction.getAlgorithms().length][13];
        this.ourAccuracy = new RollingAverage();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public RollingAverage getOurAccuracy() {
        return this.ourAccuracy;
    }

    public void onHitByBullet(HitByBulletEvent bhe) {
        ++this.hitUs;
        this.damageOnUs += World.calcBulletDamage(bhe.getPower());
    }

    double getDamageRatio(EnemyStats stats) {
        this.damageRatio = this.damageOnUs == 0.0 || this.damageOnThem == 0.0 ? 1.0 : this.damageOnThem / this.damageOnUs;
        return this.damageRatio;
    }

    private void measurePrediction(RobotSighting latestSighting, Enemy enemy, int period, int predIndex, long predTime) {
        Coord prediction = TargetPrediction.getAlgorithms()[predIndex].retrospectivelyPredict(enemy, latestSighting.getTime(), predTime);
        if (prediction != null) {
            double error = latestSighting.getTheirPosition().distanceTo(prediction);
            RollingAverage[][] predictionSet = World.getAdvancedRobot().getOthers() == 1 ? this.predictionSuccess1v1 : this.predictionSuccess;
            if (predictionSet[predIndex][period] == null) {
                predictionSet[predIndex][period] = new RollingAverage(error);
            } else {
                predictionSet[predIndex][period].nextValue(error);
            }
        }
    }

    public void measurePredictions(RobotSighting latestSighting, Enemy enemy) {
        long lastSeenTime = latestSighting.getTime();
        TargetPrediction[] algs = TargetPrediction.getAlgorithms();
        int period = 1;
        while (period <= 12) {
            int predIndex;
            long predTime = lastSeenTime - (long)(period * 10);
            if (predTime < 5L) break;
            long currentTime = World.getTime();
            if (currentTime < 100L) {
                predIndex = 0;
                while (predIndex < algs.length) {
                    this.measurePrediction(latestSighting, enemy, period, predIndex, predTime);
                    ++predIndex;
                }
            } else {
                predIndex = (int)(currentTime % (long)algs.length);
                this.measurePrediction(latestSighting, enemy, period, predIndex, predTime);
            }
            ++period;
        }
    }

    private RollingAverage[][] getCurrentPredictionArray() {
        RollingAverage[][] predictionArray = World.getOthers() == 1 ? this.predictionSuccess1v1 : this.predictionSuccess;
        return predictionArray;
    }

    public TargetPrediction getBestPrediction(int flightTime, int rank) {
        RollingAverage[][] predictionArray = this.getCurrentPredictionArray();
        return this.getBestPrediction(flightTime, predictionArray, rank);
    }

    public TargetPrediction getBestPrediction(int flightTime) {
        RollingAverage[][] predictionArray = this.getCurrentPredictionArray();
        return this.getBestPrediction(flightTime, predictionArray);
    }

    public TargetPrediction getBestPrediction(int flightTime, boolean onevone) {
        RollingAverage[][] predictionArray = onevone ? this.predictionSuccess1v1 : this.predictionSuccess;
        return this.getBestPrediction(flightTime, predictionArray);
    }

    private TargetPrediction getBestPrediction(int flightTime, RollingAverage[][] predictionArray) {
        return this.getBestPrediction(flightTime, predictionArray, 0);
    }

    private TargetPrediction getBestPrediction(int flightTime, RollingAverage[][] predictionArray, int rank) {
        TargetPrediction best = null;
        TargetPrediction[] predictionAlgorithms = TargetPrediction.getAlgorithms();
        int period = flightTime / 10 + 1;
        if (predictionArray[rank][period] == null) {
            best = TargetPrediction.CIRCULAR;
        } else {
            double lowestAverage = predictionArray[0][period].getAverage();
            best = predictionAlgorithms[0];
            int a = 0;
            while (a < predictionAlgorithms.length) {
                double thisAverage;
                if (predictionArray[a][period] != null && (thisAverage = predictionArray[a][period].getAverage()) < lowestAverage) {
                    lowestAverage = thisAverage;
                    best = predictionAlgorithms[a];
                }
                ++a;
            }
        }
        return best;
    }

    String reportPredictionAccuracyHtml(boolean onevone) {
        int p;
        RollingAverage[][] predictionArray = onevone ? this.predictionSuccess1v1 : this.predictionSuccess;
        StringBuffer report = new StringBuffer(400);
        TargetPrediction[] algs = TargetPrediction.getAlgorithms();
        String name_trailer = onevone ? " as only opponent" : " with other opponents";
        report.append("<table>\n<caption>" + this.name + name_trailer + "</caption>\n");
        int alg = 0;
        while (alg < algs.length) {
            report.append("<tr><td>" + algs[alg] + "</td>");
            p = 1;
            while (p <= 12) {
                RollingAverage av = predictionArray[alg][p];
                if (av == null) {
                    report.append("<td/>");
                } else {
                    report.append("<td>" + (int)av.getAverage() + "</td>");
                }
                ++p;
            }
            report.append("</tr>\n");
            ++alg;
        }
        report.append("<tr><td>Best choice</td>");
        p = 1;
        while (p <= 12) {
            report.append("<td>" + this.getBestPrediction((p - 1) * 10, onevone) + "</td>");
            ++p;
        }
        report.append("</tr></table>\n");
        return report.toString();
    }

    public static void main(String[] args) {
        Object[] o1 = new Object[]{"A really long heading", new Long(123456L)};
        Object[] o2 = new Object[]{"Short", new Long(123L)};
        System.out.println(MessageFormat.format("{0} : {1}", o1));
        System.out.println(MessageFormat.format("{0,,###################} : {1}", o2));
        System.out.println(MessageFormat.format("{1,,###################} : {0}", o2));
    }

    public static String padString(Object str, int len) {
        StringBuffer buffer = new StringBuffer(len);
        buffer.append(str.toString());
        while (buffer.length() < len) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    static {
        BEST_PREDICTION_RANGE = 120;
        BEST_PREDICTION_PERIODS = 12;
    }
}

