/*
 * Decompiled with CFR 0.152.
 */
package pak;

import java.awt.Point;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.TurnCompleteCondition;
import robocode.util.Utils;

public class JakeTheTestingRobot
extends AdvancedRobot {
    public void run() {
        Point p = new Point(200, 200);
        this.goTo(p);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRight(360.0);
        while (true) {
            this.setTurnRadarRight(Double.POSITIVE_INFINITY);
            this.setMaxVelocity(5);
            this.setAhead(10000.0);
            this.setTurnRight(360.0);
            this.execute();
            this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
            this.setTurnLeft(360.0);
            this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.setTurnRadarLeft(this.getRadarTurnRemaining());
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians() + e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing) / 13.0)));
        this.setFire(3);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Point p = new Point((int)this.getBattleFieldHeight() - 200, 200);
        this.goTo(p);
    }

    public double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    private final void goTo(Point2D point) {
        Point location = new Point((int)this.getX(), (int)this.getY());
        double distance = location.distance(point);
        double angle = this.normalRelativeAngle(this.absoluteBearing(location, point) - this.getHeading());
        if (Math.abs(angle) > 90.0) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= 180.0) : (angle += 180.0);
        }
        this.setTurnRight(angle);
        this.setAhead(distance);
    }

    private final double absoluteBearing(Point2D source, Point2D target) {
        return Math.toDegrees(Math.atan2(target.getX() - source.getX(), target.getY() - source.getY()));
    }
}

