/*
 * Decompiled with CFR 0.152.
 */
package taqho;

import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import taqho.Enemy;
import taqho.GameInfo;
import taqho.GunManager;
import taqho.MathUtils;
import taqho.MoveManager;
import taqho.RobotData;
import taqho.ScanManager;

public class taqbot
extends AdvancedRobot {
    Enemy target;
    final double PI = Math.PI;
    int direction = 1;
    double firePower;
    boolean bNeedsExecute = false;
    ScanManager scanner = null;
    MoveManager mover = null;
    GunManager gunner = null;
    RobotData theTarget = null;

    public void run() {
        this.initialize();
        while (true) {
            GameInfo.updateTick();
            this.mover.handleMove();
            this.theTarget = this.scanner.getATarget();
            boolean bl = this.bNeedsExecute = !this.gunner.trackAndShoot(GameInfo.getScanner().getCurrentTarget());
            if (!this.bNeedsExecute) continue;
            this.execute();
        }
    }

    public void initialize() {
        this.target = new Enemy();
        this.target.distance = 100000.0;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.green, Color.black, Color.black);
        GameInfo.setRobot(this);
        this.theTarget = null;
        this.scanner = new ScanManager();
        this.mover = new MoveManager();
        this.gunner = new GunManager();
        GameInfo.setComponents(this.scanner, this.mover, this.gunner);
        GameInfo.updateTick();
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        this.scanner.scan();
    }

    void doFirePower() {
        this.firePower = 400.0 / this.target.distance;
        if (this.firePower > 3.0) {
            this.firePower = 3.0;
        }
    }

    void doMovement() {
        if (this.getTime() % 20L == 0L) {
            this.direction *= -1;
            this.setAhead(this.direction * 300);
        }
        if (this.theTarget != null) {
            this.setTurnRight(this.theTarget.getBearingToMeVal() + 90.0);
        }
    }

    void doScanner() {
        double radarOffset;
        if (this.getTime() - this.target.ctime > 4L) {
            radarOffset = 720.0;
        } else {
            radarOffset = this.getRadarHeading() - (90.0 - MathUtils.atan2(this.target.y - this.getY(), this.target.x - this.getX()));
            radarOffset = (radarOffset = MathUtils.normaliseBearingDegrees(radarOffset)) < 0.0 ? (radarOffset -= 18.0) : (radarOffset += 18.0);
        }
        this.setTurnRadarLeft(radarOffset);
    }

    void doGun() {
        Point2D.Double p = new Point2D.Double(this.target.x, this.target.y);
        int i = 0;
        while (i < 10) {
            long nextTime = (int)Math.round(this.getrange(this.getX(), this.getY(), p.x, p.y) / (20.0 - 3.0 * this.firePower));
            long time = this.getTime() + nextTime;
            p = this.target.guessPosition(time);
            ++i;
        }
        double gunOffset = this.getGunHeading() - (90.0 - MathUtils.atan2(p.y - this.getY(), p.x - this.getX()));
        this.setTurnGunLeft(MathUtils.normaliseBearingDegrees(gunOffset));
    }

    double NormaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    double NormaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double getrange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition() instanceof RadarTurnCompleteCondition) {
            this.scanner.scan();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (e.getDistance() < this.target.distance || this.target.name == e.getName()) {
            double absbearing_deg = (this.getHeading() + e.getBearing()) % 360.0;
            this.target.name = e.getName();
            double h = MathUtils.normaliseBearingDegrees(e.getHeading() - this.target.heading);
            this.target.changeheading = h /= (double)(this.getTime() - this.target.ctime);
            this.target.x = this.getX() + MathUtils.sin(absbearing_deg) * e.getDistance();
            this.target.y = this.getY() + MathUtils.cos(absbearing_deg) * e.getDistance();
            this.target.bearing = e.getBearing();
            this.target.heading = e.getHeading();
            this.target.ctime = this.getTime();
            this.target.speed = e.getVelocity();
            this.target.distance = e.getDistance();
            this.target.bx = this.getBattleFieldWidth();
            this.target.by = this.getBattleFieldHeight();
        }
        this.scanner.onScannedRobot(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.target.name) {
            this.target.distance = 10000.0;
        }
        this.scanner.onRobotDeath(e);
    }
}

