/*
 * Decompiled with CFR 0.152.
 */
package rsalesc.roborio.utils.geo;

import robocode.util.Utils;
import rsalesc.roborio.utils.R;

public class Point {
    public double x;
    public double y;

    public Point() {
        this.setX(0.0);
        this.setY(0.0);
    }

    public Point(double d, double d2) {
        this.setX(d);
        this.setY(d2);
    }

    public Point(Point point, Point point2) {
        this.setX(point2.x - point.x);
        this.setY(point2.y - point.y);
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.y = d;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double squaredDistance(Point point) {
        return (this.x - point.x) * (this.x - point.x) + (this.y - point.y) * (this.y - point.y);
    }

    public double distance(Point point) {
        return R.sqrt(this.squaredDistance(point));
    }

    public Point add(Point point) {
        return new Point(this.x + point.x, this.y + point.y);
    }

    public Point subtract(Point point) {
        return new Point(this.x - point.x, this.y - point.y);
    }

    public Point multiply(double d) {
        return new Point(this.x * d, this.y * d);
    }

    public double absoluteBearing() {
        return R.atan2(this.x, this.y);
    }

    public Point project(double d, double d2) {
        return new Point(this.x + R.sin(d) * d2, this.y + R.cos(d) * d2);
    }

    public Point rotate(double d) {
        d = Utils.normalRelativeAngle((double)d);
        return new Point(R.cos(-d) * this.x - R.sin(-d) * this.y, R.sin(-d) * this.x + R.cos(-d) * this.y);
    }

    public Point rotate(double d, Point point) {
        return this.subtract(point).rotate(d).add(point);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

