/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics.constant;

import pedersen.debug.DebuggableBase;
import pedersen.physics.Circle;
import pedersen.physics.HasPosition;
import pedersen.physics.HasVelocity;
import pedersen.physics.HasWave;
import pedersen.physics.Magnitude;
import pedersen.physics.Position;
import pedersen.physics.Velocity;
import pedersen.physics.Wave;
import pedersen.physics.constant.CircleImpl;
import pedersen.physics.constant.PositionImpl;
import pedersen.physics.constant.VelocityImpl;

public class WaveImpl
extends DebuggableBase
implements Wave {
    private final Position position;
    private final Velocity velocity;
    private final long timeOfCreation;

    public WaveImpl(long timeOfCreation, HasPosition position, HasVelocity velocity) {
        this.position = position.getPosition();
        this.velocity = velocity.getVelocity();
        this.timeOfCreation = timeOfCreation;
    }

    public WaveImpl(HasWave other) {
        this(other.getWave().getTimeOfCreation(), other.getWave().getPosition(), other.getWave().getVelocity());
    }

    public WaveImpl(long timeOfCreation, double x, double y, double v) {
        this(timeOfCreation, new PositionImpl(x, y), new VelocityImpl(v));
    }

    @Override
    public Wave getWave() {
        return this;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Velocity getVelocity() {
        return this.velocity;
    }

    public Magnitude getMagnitude() {
        return this.getVelocity();
    }

    @Override
    public long getTimeOfCreation() {
        return this.timeOfCreation;
    }

    @Override
    public Circle getCircle(long time) {
        return new CircleImpl((HasPosition)this.position, this.radius(time));
    }

    @Override
    public double radius(long time) {
        return this.velocity.velocity() * (double)(time - this.getTimeOfCreation());
    }

    @Override
    public boolean equalsWave(HasWave other) {
        return this.position.equalsPosition(other.getWave().getPosition()) && this.velocity.equalsVelocity(other.getWave().getVelocity()) && this.timeOfCreation == other.getWave().getTimeOfCreation();
    }
}

