/*
 * Decompiled with CFR 0.152.
 */
package pedersen.systems;

import java.awt.Color;
import pedersen.core.Combatant;
import pedersen.core.GameState;
import pedersen.core.Instructions;
import pedersen.debug.DebuggableBase;
import pedersen.debug.renderable.GraphicalDebugger;
import pedersen.divination.WaveOutboundImpl;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;
import pedersen.physics.Firepower;
import pedersen.physics.HasVehicle;
import pedersen.physics.Snapshot;
import pedersen.physics.constant.WaveImpl;
import pedersen.systems.CommunicationSubsystem;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.systems.notifier.OnRound;
import pedersen.team.communication.CommuniqueMyBulletTarget;
import pedersen.util.Conversions;

public class TurretSubsystem
extends DebuggableBase
implements OnRound {
    private Target target;
    private boolean targetLock = false;
    private static TurretSubsystem singleton = new TurretSubsystem();

    private TurretSubsystem() {
        NotificationSubsystem.getInstance().subscribeOnRound(this);
    }

    public static TurretSubsystem getInstance() {
        return singleton;
    }

    public WaveOutboundImpl getOutboundWave(HasVehicle firingPosition) {
        WaveOutboundImpl outboundWave = null;
        if (this.target != null && this.target.isActive()) {
            Snapshot targetSnapshotAtTimeOfAiming = this.target.getHistoricalSnapshot(0L);
            if (targetSnapshotAtTimeOfAiming != null) {
                Firepower firepower = this.target.getFireControl().getFirepower(firingPosition.getVehicle(), this.target.getSnapshot());
                WaveImpl wave = new WaveImpl(GameState.getInstance().getTurnAfter(), firingPosition.getVehicle(), Conversions.getBulletVelocityFromFirepower(firepower));
                outboundWave = new WaveOutboundImpl(wave);
                if (outboundWave.firingSolution != null) {
                    Instructions.getInstance().setTurretDirectionChange(outboundWave.firingSolution);
                } else {
                    Instructions.getInstance().setTurretDirectionChange(firingPosition.getVehicle().getPosition().getBearing(this.target.getSnapshot()));
                }
            }
        } else {
            Instructions.getInstance().setTurretDirectionChange(firingPosition.getVehicle());
        }
        if (GraphicalDebugger.paintTurretSubsystem && this.target != null && this.target.isActive()) {
            GraphicalDebugger.addLineTurnScope(Combatant.getCombatant().getSnapshot().getPosition(), this.target.getSnapshot().getPosition(), Color.red);
        }
        return outboundWave;
    }

    public void considerTarget(Target target) {
        this.setTarget(this.getBestTarget());
    }

    private Target getBestTarget() {
        Target bestTarget = this.target;
        if (!GameState.getInstance().isInDuelMode() && GameState.getInstance().getTurn() < 8L) {
            bestTarget = null;
        } else {
            double bestTargetValue = Double.POSITIVE_INFINITY;
            for (Target target : TargetBank.getInstance().getActiveTargets()) {
                double e = target.getSnapshot().getEnergy().energy();
                double targetValue = GameState.getInstance().getDistance(target.getSnapshot()).distance() * e * e;
                if (e > 150.0) {
                    this.targetLock = false;
                    this.setTarget(target);
                    this.targetLock = true;
                    continue;
                }
                if (!(targetValue < bestTargetValue)) continue;
                bestTarget = target;
                bestTargetValue = targetValue;
            }
        }
        return bestTarget;
    }

    public void setTarget(Target target) {
        Target originalTarget = this.target;
        if (this.target != null && !this.target.isActive()) {
            this.target = null;
        }
        if (this.target == null) {
            this.targetLock = false;
        }
        if (!this.targetLock && target != null && target.isActive()) {
            this.target = target;
        }
        if (this.target != originalTarget) {
            Combatant.getCombatant().recalibrate();
            if (this.target != null) {
                CommunicationSubsystem.getInstance().prepareCommunique(new CommuniqueMyBulletTarget(this.target.getName()));
            }
        }
    }

    public void onRobotDeath(Target target) {
        if (target.equals(this.target)) {
            this.targetLock = false;
            this.setTarget(null);
        }
    }

    @Override
    public void onRound(int round) {
        this.setTarget(null);
    }

    public Target getTarget() {
        return this.target;
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("\n").append("Target: " + (this.target == null ? "(no target)" : this.target.getName()));
        return buffer.toString();
    }
}

