/*
 * Decompiled with CFR 0.152.
 */
package rdt199.util;

import rdt199.util.Location;
import rdt199.util.RobotLog;
import rdt199.util.RobotLogger;
import rdt199.util.RobotSnapshot;
import rdt199.util.SelfLog;
import robocode.AdvancedRobot;

public class BotFuncs {
    protected static boolean m_bTargetHit;
    protected static double m_dTargetDamage;
    protected static int EDGE_ACCURACY;
    public static AdvancedRobot m_AdvancedRobot;
    public static RobotLogger m_RobotLogger;
    protected static RobotLog m_Target;
    protected static SelfLog m_SelfLog;

    static {
        EDGE_ACCURACY = 40;
    }

    public BotFuncs(AdvancedRobot robot) {
        m_AdvancedRobot = robot;
        m_Target = null;
    }

    public static void setTarget(String name) {
        m_Target = m_RobotLogger.getRobotLog(name);
    }

    public static void setLogger(RobotLogger logger) {
        m_RobotLogger = logger;
    }

    public static RobotLog getTarget() {
        return m_Target;
    }

    public static void setSelfLog(SelfLog log) {
        m_SelfLog = log;
    }

    public static SelfLog getSelfLog() {
        return m_SelfLog;
    }

    public static void setHitTarget(boolean b, double damage) {
        m_bTargetHit = b;
        m_dTargetDamage = damage;
    }

    public static boolean getHitTarget() {
        return m_bTargetHit;
    }

    public static double getTargetDamage() {
        return m_dTargetDamage;
    }

    public static double getDistanceBetween(Location loc1, Location loc2) {
        if (loc1 == null || loc2 == null) {
            return 0.0;
        }
        double dDiffX = loc2.getX() - loc1.getX();
        double dDiffY = loc2.getY() - loc1.getY();
        return Math.sqrt(dDiffX * dDiffX + dDiffY * dDiffY);
    }

    public static double getDistanceBetween(double x1, double y1, double x2, double y2) {
        return BotFuncs.getDistanceBetween(new Location(x1, y1), new Location(x2, y2));
    }

    public static double getAbsBearing(Location loc1, Location loc2) {
        return Math.atan2(loc1.getX() - loc2.getX(), loc1.getY() - loc2.getY());
    }

    public static double getAbsBearing(double x1, double y1, double x2, double y2) {
        return BotFuncs.getAbsBearing(new Location(x1, y1), new Location(x2, y2));
    }

    public static double normaliseRelDegrees(double angle) {
        double dAngleRadians = Math.toRadians(angle);
        dAngleRadians = BotFuncs.normaliseRelRadians(dAngleRadians);
        return Math.toDegrees(dAngleRadians);
    }

    public static double normaliseRelRadians(double angle) {
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static double normaliseAbsDegrees(double angle) {
        double dAngleRadians = Math.toRadians(angle);
        dAngleRadians = BotFuncs.normaliseAbsRadians(dAngleRadians);
        return Math.toDegrees(dAngleRadians);
    }

    public static double normaliseAbsRadians(double angle) {
        while (angle >= Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static boolean isInBattlefield(Location loc) {
        if (loc.getX() < 0.0 || loc.getX() > m_AdvancedRobot.getBattleFieldWidth()) {
            return false;
        }
        return !(loc.getY() < 0.0) && !(loc.getY() > m_AdvancedRobot.getBattleFieldHeight());
    }

    public static double getFirepower(double distance) {
        if (m_Target == null) {
            return -1.0;
        }
        RobotSnapshot Snap = m_Target.get(0);
        if (Snap == null) {
            return -1.0;
        }
        double dDamageNeededToKill = BotFuncs.getDamageNeededToKill(Snap);
        if (dDamageNeededToKill <= 3.0) {
            if (dDamageNeededToKill < 0.1) {
                dDamageNeededToKill = 0.1;
            }
            if (dDamageNeededToKill < m_AdvancedRobot.getEnergy()) {
                return dDamageNeededToKill;
            }
        }
        double dRandom = Math.random() * 100.0;
        double dFirepower = 0.0;
        dFirepower = m_AdvancedRobot.getOthers() > 2 ? 300.0 / distance : 900.0 / distance;
        if (dRandom > 90.0) {
            dFirepower = 3.0;
        } else if (dRandom > 80.0) {
            dFirepower = 0.1;
        }
        if (dFirepower > 3.0) {
            dFirepower = 3.0;
        }
        if (dFirepower >= m_AdvancedRobot.getEnergy() && (dFirepower -= 0.2) >= m_AdvancedRobot.getEnergy()) {
            return -1.0;
        }
        if (dFirepower < 0.1) {
            dFirepower = 0.1;
        }
        return dFirepower;
    }

    public static double getDamageNeededToKill(RobotSnapshot snap) {
        return snap.m_dEnergy / 4.0;
    }

    public static Location adjustForWalls(Location loc) {
        Location NewLoc = new Location(loc.getX(), loc.getY());
        if (loc.getX() < (double)EDGE_ACCURACY) {
            NewLoc.setX(EDGE_ACCURACY + 10);
        } else if (m_AdvancedRobot.getBattleFieldWidth() - (double)EDGE_ACCURACY < loc.getX()) {
            NewLoc.setX(m_AdvancedRobot.getBattleFieldWidth() - (double)EDGE_ACCURACY - 10.0);
        }
        if (loc.getY() < (double)EDGE_ACCURACY) {
            NewLoc.setY(EDGE_ACCURACY + 10);
        } else if (m_AdvancedRobot.getBattleFieldHeight() - (double)EDGE_ACCURACY < loc.getY()) {
            NewLoc.setY(m_AdvancedRobot.getBattleFieldHeight() - (double)EDGE_ACCURACY - 10.0);
        }
        return NewLoc;
    }
}

