/*
 * Decompiled with CFR 0.152.
 */
package rdt199.util;

import rdt199.gun.CircularMode;
import rdt199.gun.GunManager;
import rdt199.gun.HalfVelocityCircularMode;
import rdt199.gun.HistoryMatchMode;
import rdt199.gun.StraightMode;
import rdt199.gun.VelocityAverageCircularMode;
import rdt199.gun.VelocityFactorMode;
import rdt199.util.BotFuncs;
import rdt199.util.FileHandler;
import rdt199.util.Location;
import rdt199.util.RobotSnapshot;
import rdt199.util.Storage;

public class RobotLog {
    protected String m_Name;
    protected Storage m_Snapshots;
    protected boolean m_bAlive;
    protected RobotSnapshot m_Prev;
    protected FileHandler m_FileHandler;
    protected GunManager m_GunManagerClose;
    protected GunManager m_GunManagerMedium;
    protected GunManager m_GunManagerFar;
    protected static double CLOSE_DISTANCE = 150.0;
    protected static double MEDIUM_DISTANCE = 350.0;

    public RobotLog() {
    }

    public RobotLog(String name, String prefix) {
        this.m_Name = name;
        this.m_bAlive = true;
        this.m_Snapshots = new Storage(500);
        this.m_Prev = null;
        this.m_FileHandler = new FileHandler(String.valueOf(prefix) + name + ".txt");
        this.m_GunManagerClose = new GunManager(6);
        this.m_GunManagerClose.addMode(new StraightMode(this, "close_"));
        this.m_GunManagerClose.addMode(new CircularMode(this, "close_"));
        this.m_GunManagerClose.addMode(new HalfVelocityCircularMode(this, "close_"));
        this.m_GunManagerClose.addMode(new VelocityAverageCircularMode(this, "close_"));
        this.m_GunManagerClose.addMode(new VelocityFactorMode(this, "close_"));
        this.m_GunManagerClose.addMode(new HistoryMatchMode(this, "close_"));
        this.m_GunManagerMedium = new GunManager(6);
        this.m_GunManagerMedium.addMode(new StraightMode(this, "medium_"));
        this.m_GunManagerMedium.addMode(new CircularMode(this, "medium_"));
        this.m_GunManagerMedium.addMode(new HalfVelocityCircularMode(this, "medium_"));
        this.m_GunManagerMedium.addMode(new VelocityAverageCircularMode(this, "medium_"));
        this.m_GunManagerMedium.addMode(new VelocityFactorMode(this, "medium_"));
        this.m_GunManagerMedium.addMode(new HistoryMatchMode(this, "medium_"));
        this.m_GunManagerFar = new GunManager(6);
        this.m_GunManagerFar.addMode(new StraightMode(this, "far_"));
        this.m_GunManagerFar.addMode(new CircularMode(this, "far_"));
        this.m_GunManagerFar.addMode(new HalfVelocityCircularMode(this, "far_"));
        this.m_GunManagerFar.addMode(new VelocityAverageCircularMode(this, "far_"));
        this.m_GunManagerFar.addMode(new VelocityFactorMode(this, "far_"));
        this.m_GunManagerFar.addMode(new HistoryMatchMode(this, "far_"));
    }

    public void update(RobotSnapshot snap) {
        if (this.m_Prev != null) {
            snap.m_dDeltaAngle = BotFuncs.normaliseAbsDegrees(snap.m_dAngle - this.m_Prev.m_dAngle);
            snap.m_dDeltaVelocity = snap.m_dVelocity - this.m_Prev.m_dVelocity;
        }
        this.m_Snapshots.add(snap);
        this.m_Prev = snap;
    }

    public RobotSnapshot get(int index) {
        return (RobotSnapshot)this.m_Snapshots.get(index);
    }

    public int getSnapshotSize() {
        return this.m_Snapshots.size();
    }

    public String getName() {
        return this.m_Name;
    }

    public boolean isAlive() {
        return this.m_bAlive;
    }

    public void kill() {
        this.m_bAlive = false;
    }

    public GunManager getGunManager() {
        RobotSnapshot Snap = this.get(0);
        if (Snap == null) {
            return null;
        }
        Location Loc = new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY());
        double dDistance = BotFuncs.getDistanceBetween(Snap.m_Location, Loc);
        if (dDistance < CLOSE_DISTANCE) {
            return this.m_GunManagerClose;
        }
        if (dDistance < MEDIUM_DISTANCE) {
            return this.m_GunManagerMedium;
        }
        return this.m_GunManagerFar;
    }

    public void close() {
        this.m_GunManagerClose.close();
        this.m_GunManagerMedium.close();
        this.m_GunManagerFar.close();
        this.m_FileHandler.saveItems();
    }

    public FileHandler getFileHandler() {
        return this.m_FileHandler;
    }
}

