/*
 * Decompiled with CFR 0.152.
 */
package bing2;

import bing2.Gun;
import bing2.MathUtils;
import bing2.Position;
import bing2.Wave;
import java.io.PrintStream;
import java.util.ArrayList;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;

public class WaveTracker {
    private boolean selfWave = false;
    public ArrayList<Wave> waves = new ArrayList();
    public ArrayList<Wave> hitWaves = new ArrayList();
    public ArrayList<Wave> trash = new ArrayList();
    public int waveCount = 0;
    public static final int NumBins = 45;
    public static final int NumGroups = 1;
    public static final int GRP_DEFAULT = 0;
    VisitStat[] allStats = new VisitStat[1];

    public WaveTracker() {
        this(false);
    }

    public WaveTracker(boolean bl) {
        this.selfWave = bl;
        for (int i = 0; i < this.allStats.length; ++i) {
            this.allStats[i] = new VisitStat();
        }
    }

    public void onRoundStart() {
        this.waves.clear();
        this.hitWaves.clear();
        this.waveCount = 0;
    }

    public void updateWaves(long l, Position position) {
        this.trash.clear();
        for (Wave wave : this.waves) {
            wave.update(l - wave.createTime);
            double d = wave.distance(position);
            if (d <= -50.0) {
                this.trash.add(wave);
                continue;
            }
            if (!this.selfWave && Math.abs(d) < 36.0) {
                wave.hitTime = l;
                wave.hitPosition = position;
                this.hitWaves.add(wave.clone());
                continue;
            }
            if (!this.selfWave || !(Math.abs(d) < 18.0)) continue;
            wave.hitTime = l;
            wave.hitPosition = position;
            this.accumulateVisitCount(this.allStats[0], wave);
        }
        for (Wave wave : this.trash) {
            this.waves.remove(wave);
        }
        this.trash.clear();
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        if (this.selfWave) {
            return;
        }
        long l = 5L;
        int n = -1;
        for (int i = this.hitWaves.size() - 1; i >= 0; --i) {
            Wave wave = this.hitWaves.get(i);
            long l2 = Math.abs(wave.hitTime - hitByBulletEvent.getTime());
            if (Math.round(Gun.getBulletVelocity(hitByBulletEvent.getBullet().getPower()) * 10.0) != Math.round(wave.velocity * 10.0) || l2 >= l) continue;
            l = l2;
            n = i;
            if (l == 0L) break;
        }
        if (n >= 0) {
            this.accumulateVisitCount(this.allStats[0], this.hitWaves.get(n));
        }
        this.hitWaves.clear();
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        Bullet bullet = bulletHitBulletEvent.getBullet();
        Bullet bullet2 = bulletHitBulletEvent.getHitBullet();
        Position position = new Position(bullet.getX(), bullet.getY());
        if (!this.selfWave) {
            double d = 5.0;
            int n = -1;
            for (int i = this.waves.size() - 1; i >= 0; --i) {
                Wave wave = this.waves.get(i);
                double d2 = Math.abs(wave.distance(position));
                if (Math.round(Gun.getBulletVelocity(bullet2.getPower()) * 10.0) != Math.round(wave.velocity * 10.0) || !(d2 < d)) continue;
                d = d2;
                n = i;
                if (d == 0.0) break;
            }
            if (n >= 0) {
                // empty if block
            }
        }
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        if (!this.selfWave) {
            return;
        }
    }

    public void addWave(double d, double d2, double d3, long l, double d4, int n) {
        this.waves.add(new Wave(d, d2, d3, l, d4, n));
        ++this.waveCount;
    }

    public String toString() {
        String string = "WaveTracker:\n\twaves.size() = " + this.waves.size() + "\n" + "\thitWaves.size() = " + this.hitWaves.size() + "\n";
        for (Wave wave : this.waves) {
            string = string + wave.toString() + "\n";
        }
        string = string + "-------------------------\n";
        for (Wave wave : this.hitWaves) {
            string = string + wave.toString() + "\n";
        }
        return string;
    }

    void accumulateVisitCount(VisitStat visitStat, Wave wave) {
        int n = this.getBinIndex(wave, wave.hitPosition);
        int n2 = 0;
        while (n2 < 45) {
            double d = 1.0 / (Math.pow(n - n2, 2.0) + 1.0);
            int n3 = n2++;
            visitStat.visitStat[n3] = visitStat.visitStat[n3] + d;
            visitStat.visitCount += d;
        }
        ++visitStat.samples;
    }

    public static double maxEscapeAngle(double d) {
        return Math.asin(8.0 / d);
    }

    public Wave closestWave(Position position) {
        double d = 1000.0;
        Wave wave = null;
        for (int i = this.waves.size() - 1; i >= 0; --i) {
            Wave wave2 = this.waves.get(i);
            double d2 = wave2.distance(position);
            if (!(d2 > 50.0) || !(d2 < d)) continue;
            d = d2;
            wave = wave2;
        }
        return wave;
    }

    public int getBinIndex(Wave wave, Position position) {
        double d = MathUtils.bearing(position, wave.center);
        double d2 = d - wave.targetInitialBearing;
        double d3 = MathUtils.normalizeRadians(d2) / WaveTracker.maxEscapeAngle(wave.velocity) * (double)wave.targetInitialDirection;
        return (int)MathUtils.limit(d3 * 44.0 / 2.0 + 22.0, 0.0, 44.0);
    }

    public double getVisitStat(Wave wave, Position position) {
        int n = this.getBinIndex(wave, position);
        return this.allStats[0].visitStat[n];
    }

    public static double convertBinIndexToRelativeBearing(double d, int n) {
        double d2 = WaveTracker.maxEscapeAngle(Gun.getBulletVelocity(d));
        return d2 * (double)(n - 22) / 22.0;
    }

    public void reportStatistics(PrintStream printStream) {
        for (int i = 0; i < this.allStats.length; ++i) {
            printStream.print(this.selfWave ? "Self Wave " : "Enemy Wave ");
            printStream.println("Group[" + i + "]: count = " + this.allStats[i].visitCount + ", samples = " + this.allStats[i].samples + "\n" + ", entropy = " + MathUtils.entropy(this.allStats[i].visitStat, this.allStats[i].visitCount) + ", maxEntropy = " + MathUtils.maxEntropy(this.allStats[i].visitStat.length));
            for (int j = 0; j < this.allStats[i].visitStat.length; ++j) {
                printStream.println(j + ": " + this.allStats[i].visitStat[j]);
            }
        }
    }

    public class VisitStat {
        public double[] visitStat = new double[45];
        public double visitCount = 0.0;
        public long samples = 0L;
    }
}

