/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement;

import pedersen.physics.StaticPosition;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;
import pedersen.tactics.movement.MovementMethodBase;

public abstract class MovementMethodTangentBase
extends MovementMethodBase {
    protected boolean clockwise = true;

    protected MovementMethodTangentBase(int movementMethod) {
        super(movementMethod);
    }

    protected StaticVector getTangentalVector(StaticPosition combatant, StaticPosition target) {
        return this.getTangentalVector(combatant, target, 50.0);
    }

    protected StaticVector getTangentalVector(StaticPosition combatant, StaticPosition target, double vectorLength) {
        return MovementMethodTangentBase.getTangentalVector(combatant, target, vectorLength, this.clockwise);
    }

    public static StaticVector getTangentalVector(StaticPosition combatant, StaticPosition target, double vectorLength, boolean clockwise) {
        StaticVectorImpl vector = null;
        if (target != null) {
            double heading = combatant.getBearing(target) + (clockwise ? -1.5707963267948966 : 1.5707963267948966);
            vector = new StaticVectorImpl(heading, vectorLength);
        }
        return vector;
    }

    protected void reverseDirection() {
        this.clockwise = !this.clockwise;
    }
}

