/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot;

import cbot.cbot.CBot;
import cbot.cbot.CU;
import cbot.cbot.Point;
import cbot.cbot.Pray;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import robocode.ScannedRobotEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PrayManager {
    private CBot robot;
    private Hashtable flock;
    private Hashtable deadFlock;
    private Pray currentPray;
    private int radarDirection;

    public Pray add(ScannedRobotEvent e) {
        if (this.flock.containsKey(e.getName())) {
            this.currentPray = (Pray)this.flock.get(e.getName());
            this.currentPray.update(e, this.robot);
        } else {
            this.currentPray = new Pray(e, this.robot);
            this.flock.put(this.currentPray.getName(), this.currentPray);
        }
        return this.currentPray;
    }

    public void remove(String name) {
        if (this.flock.containsKey(name)) {
            this.deadFlock.put(name, this.flock.remove(name));
        }
    }

    public void clear() {
        this.deadFlock.putAll(this.flock);
        this.flock.clear();
    }

    public Enumeration getDeadFlockEnumeration() {
        return this.deadFlock.elements();
    }

    public Pray getPray() {
        if (this.robot.getOthers() == 0) {
            return null;
        }
        this.currentPray = this.getClosestPray();
        return this.currentPray;
    }

    public Pray getCurrentPray() {
        return this.currentPray;
    }

    public Pray getClosestPray() {
        if (this.getNumberOfPray() == 0) {
            return null;
        }
        Iterator itr = this.flock.values().iterator();
        Point robotCord = this.robot.getCordinate();
        Pray closestPray = null;
        double closestDistance = 10000.0;
        while (itr.hasNext()) {
            Point prayCord;
            double dist;
            Pray pray = (Pray)itr.next();
            if (!this.isPrayUpToDate(pray) || !((dist = robotCord.getDistance(prayCord = pray.getCordinate())) < closestDistance)) continue;
            closestPray = pray;
            closestDistance = dist;
        }
        return closestPray;
    }

    public Pray getPray(String name) {
        Iterator itr = this.flock.values().iterator();
        while (itr.hasNext()) {
            Pray pray = (Pray)itr.next();
            if (!pray.getName().equals(name)) continue;
            return pray;
        }
        return null;
    }

    public Iterator getPrayIterator() {
        return this.flock.values().iterator();
    }

    public boolean isCurrentPray(String name) {
        if (this.currentPray == null) {
            return false;
        }
        return name.equals(this.currentPray.getName());
    }

    public int getNumberOfPray() {
        return this.flock.size();
    }

    public double getRadarTurningAngle() {
        double bearing = 0.0;
        double absBearing = 0.0;
        int scanned = 0;
        Iterator itr = this.flock.values().iterator();
        while (itr.hasNext()) {
            Pray pray = (Pray)itr.next();
            if (!this.isPrayUpToDate(pray)) break;
            ++scanned;
            double tmpBearing = CU.normalRelativeAngle(this.robot.getHeading() + pray.getBearing() - this.robot.getRadarHeading());
            if (!(Math.abs(tmpBearing) > absBearing)) continue;
            bearing = tmpBearing;
            absBearing = Math.abs(tmpBearing);
        }
        double someExtraAngle = this.robot.getOthers() == 1 ? 0.8 * absBearing : 10.0;
        double angle = scanned == this.robot.getOthers() ? CU.sign(bearing) * (absBearing + someExtraAngle) : (double)(180 * this.radarDirection);
        this.radarDirection = (int)CU.sign(angle);
        return angle;
    }

    private final boolean isPrayUpToDate(Pray pray) {
        boolean bl = false;
        if (pray.getTime() >= this.robot.getTime() - 10L) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.currentPray = null;
        this.radarDirection = -1;
    }

    public PrayManager(CBot robot) {
        this.this();
        this.robot = robot;
        int numOfPray = robot.getOthers();
        this.flock = new Hashtable(numOfPray);
        this.deadFlock = new Hashtable(numOfPray);
    }
}

