/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.DangerPrediction;

import rdt.Wraith.DangerPrediction.CachedVelocityData;
import rdt.Wraith.DangerPrediction.CommandSequence;
import rdt.Wraith.DangerPrediction.Evaluators.ClosestDistanceToEachBullet;
import rdt.Wraith.DangerPrediction.IMovementSearch;
import rdt.Wraith.DangerPrediction.MovementCommand;
import rdt.Wraith.DangerPrediction.PredictedRobotState;
import rdt.Wraith.DangerPrediction.Search.RHEA;
import rdt.Wraith.EnemyPrediction.BulletPrediction;
import rdt.Wraith.EnemyPrediction.IEnemyPredictionEventHandler;
import rdt.Wraith.EnemyPrediction.IEnemyPredictionManager;
import rdt.Wraith.IRobot;
import rdt.Wraith.IRoundStartedEventHandler;
import rdt.Wraith.Profiling.Profiler;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.RobotSnapshots.RobotSnapshotUtils;
import rdt.Wraith.Stats.Average;
import rdt.Wraith.Stats.IStats;
import rdt.Wraith.Targeting.ITargeting;
import rdt.Wraith.Targeting.Target;

public class DangerPrediction
implements IEnemyPredictionEventHandler,
IRoundStartedEventHandler {
    private IRobot _robot;
    private IMovementSearch _movementSearch;
    private IEnemyPredictionManager _enemyPredictionManager;
    private ITargeting _targeting;
    private boolean _resetSearch;
    private final int _minActiveSequenceLength;
    private int _iterations = 0;
    private int _rolls = 0;
    private final Average _averageIterationsBetweenResets = new Average("DangerPrediction : Iterations Between Resets");
    private final Average _averageRollsBetweenResets = new Average("DangerPrediction : Rolls Between Resets");
    private final Average _averageSequenceLength = new Average("DangerPrediction: Sequence Length");
    private final Average _averageTicksForRealBulletsToLeaveBattlefield = new Average("DangerPrediction: Average ticks for real bullets to leave battlefield");
    private final Average _averageTicksForAllBulletsToLeaveBattlefield = new Average("DangerPrediction: Average ticks for all bullets to leave battlefield");
    private final Average _averageTicksTakingIntoAccountCanHitTarget = new Average("DangerPrediction: Average ticks taking into account possibility of hitting target");
    private PredictedRobotState _currentRobotState = new PredictedRobotState();
    private PredictedRobotState _nextRobotState = new PredictedRobotState();

    public DangerPrediction(IRobot robot, IEnemyPredictionManager enemyPredictionManager, ITargeting targeting, IStats stats) {
        this._robot = robot;
        this._enemyPredictionManager = enemyPredictionManager;
        this._targeting = targeting;
        stats.RegisterStat(this._averageIterationsBetweenResets);
        stats.RegisterStat(this._averageRollsBetweenResets);
        stats.RegisterStat(this._averageSequenceLength);
        stats.RegisterStat(this._averageTicksForAllBulletsToLeaveBattlefield);
        stats.RegisterStat(this._averageTicksForRealBulletsToLeaveBattlefield);
        stats.RegisterStat(this._averageTicksTakingIntoAccountCanHitTarget);
        this._resetSearch = true;
        this._robot.RegisterForEventHandling(this);
        enemyPredictionManager.RegisterForEventHandling(this);
        double maxBattlefieldDimension = Math.max(this._robot.getBattleFieldWidth(), this._robot.getBattleFieldHeight());
        double ticksToEscapeCorner = 25.0;
        this._minActiveSequenceLength = (int)ticksToEscapeCorner;
        this._movementSearch = new RHEA(new ClosestDistanceToEachBullet(this._robot, enemyPredictionManager, this._targeting), 140);
    }

    public void Update() {
        Profiler.StartScope("DangerPrediction:Update");
        if (this._resetSearch) {
            this._movementSearch.Reset(this.CalcActiveSequenceLength());
            this._averageIterationsBetweenResets.Record(this._iterations);
            this._averageRollsBetweenResets.Record(this._rolls);
            this._iterations = 0;
            this._rolls = 0;
            this._resetSearch = false;
        }
        for (int iterationCount = 0; iterationCount < 3; ++iterationCount) {
            this._movementSearch.RunOneIteration();
            ++this._iterations;
        }
        CommandSequence bestCommandSequence = this._movementSearch.GetBestMovementSequence();
        int bestCommand = bestCommandSequence.Sequence[0];
        this.ExecuteCommand(bestCommand);
        this.UpdateFutureRobotPositions(bestCommandSequence);
        this._movementSearch.Roll(bestCommand);
        ++this._rolls;
        Profiler.EndScope();
    }

    @Override
    public void OnRoundStartedEvent() {
        this._resetSearch = true;
    }

    @Override
    public void OnEnemyBulletPredictionChangedEvent() {
        this._resetSearch = true;
    }

    private void ExecuteCommand(int movementCommand) {
        switch (movementCommand) {
            case 0: {
                this._robot.setAhead(1000.0);
                this._robot.setTurnLeft(0.0);
                break;
            }
            case 3: {
                this._robot.setBack(1000.0);
                this._robot.setTurnLeft(0.0);
                break;
            }
            case 1: {
                this._robot.setAhead(1000.0);
                this._robot.setTurnLeft(180.0);
                break;
            }
            case 5: {
                this._robot.setBack(1000.0);
                this._robot.setTurnLeft(180.0);
                break;
            }
            case 2: {
                this._robot.setAhead(1000.0);
                this._robot.setTurnRight(180.0);
                break;
            }
            case 4: {
                this._robot.setBack(1000.0);
                this._robot.setTurnRight(180.0);
            }
        }
    }

    private int CalcActiveSequenceLength() {
        int bullets = this._enemyPredictionManager.GetBulletPredictionCount();
        if (bullets <= 0) {
            return this._minActiveSequenceLength;
        }
        BulletPrediction[] bulletPredictions = this._enemyPredictionManager.GetBulletPredictions();
        long maxPredictionTickRealBullets = this._robot.getTime();
        long maxPredictionTickAllBullets = this._robot.getTime();
        long maxPredictionTickAllBulletsCanHitTarget = this._robot.getTime();
        for (int bulletIndex = 0; bulletIndex < bullets; ++bulletIndex) {
            BulletPrediction bulletPrediction = bulletPredictions[bulletIndex];
            if (!bulletPrediction.FuturePrediction) {
                maxPredictionTickRealBullets = Math.max(maxPredictionTickRealBullets, bulletPrediction.PredictionDeactivationTime - 1L);
            }
            maxPredictionTickAllBullets = Math.max(maxPredictionTickAllBullets, bulletPrediction.PredictionDeactivationTime - 1L);
            maxPredictionTickAllBulletsCanHitTarget = Math.max(maxPredictionTickAllBulletsCanHitTarget, bulletPrediction.LastPossibleInterceptTime);
        }
        long ticksForAllBulletsToLeaveBattlefield = maxPredictionTickAllBullets - this._robot.getTime();
        long ticksForRealBulletsToLeaveBattlefield = maxPredictionTickRealBullets - this._robot.getTime();
        long ticksTakingIntoAccountCanHitTarget = maxPredictionTickAllBulletsCanHitTarget - this._robot.getTime();
        assert (ticksForAllBulletsToLeaveBattlefield <= 140L) : "It is taking " + ticksForAllBulletsToLeaveBattlefield + "ticks for bullets to leave battlefield, but max command sequence length is " + 140;
        this._averageTicksForRealBulletsToLeaveBattlefield.Record(ticksForRealBulletsToLeaveBattlefield);
        this._averageTicksForAllBulletsToLeaveBattlefield.Record(ticksForAllBulletsToLeaveBattlefield);
        this._averageTicksTakingIntoAccountCanHitTarget.Record(ticksTakingIntoAccountCanHitTarget);
        long sequenceLength = Math.max(this._minActiveSequenceLength, (int)ticksForAllBulletsToLeaveBattlefield);
        this._averageSequenceLength.Record(Math.max(this._minActiveSequenceLength, (int)sequenceLength));
        return (int)sequenceLength;
    }

    private void UpdateFutureRobotPositions(CommandSequence bestCommandSequence) {
        this._currentRobotState.X = this._robot.getX();
        this._currentRobotState.Y = this._robot.getY();
        this._currentRobotState.Heading = this._robot.getHeadingRadians();
        this._currentRobotState.Velocity = this._robot.getVelocity();
        Target ourCurrentTarget = this._targeting.GetCurrentTarget();
        PredictedRobotState previousState = this._currentRobotState;
        PredictedRobotState predictedStateFast = this._nextRobotState;
        long startingTick = this._robot.getTime() + 1L;
        int roundNum = this._robot.getRoundNum();
        CachedVelocityData cachedVelocityData = CachedVelocityData.Get(previousState.Velocity);
        int sequenceLength = bestCommandSequence.ActiveLength;
        int[] sequenceCommands = bestCommandSequence.Sequence;
        for (int index = 0; index < sequenceLength; ++index) {
            cachedVelocityData = MovementCommand.PredictCommandFast(sequenceCommands[index], previousState, predictedStateFast, cachedVelocityData);
            long predictedTick = startingTick + (long)index;
            RobotSnapshot futureSnapshot = this._robot.WriteRobotSnapshot(predictedTick);
            this._robot.SetMaxPredictedTick(predictedTick);
            double targetPositionX = 0.0;
            double targetPositionY = 0.0;
            if (ourCurrentTarget != null && ourCurrentTarget.Valid) {
                long targetPredictedSnapshotTick = ourCurrentTarget.GetSafePredictedTick(predictedTick);
                RobotSnapshot ourTargetAtPredictedTick = ourCurrentTarget.RobotSnapshots.Read(targetPredictedSnapshotTick);
                targetPositionX = ourTargetAtPredictedTick.LocationX;
                targetPositionY = ourTargetAtPredictedTick.LocationY;
            }
            RobotSnapshotUtils.FillInSnapshot(futureSnapshot, roundNum, predictedTick, predictedStateFast.X, predictedStateFast.Y, predictedStateFast.Velocity, predictedStateFast.Heading, targetPositionX, targetPositionY, this._robot.getEnergy(), this._robot.GetRobotSnapshots());
            previousState = predictedStateFast;
        }
    }
}

