/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.EnemyPrediction;

import rdt.Wraith.EnemyPrediction.PredictedPosition;
import rdt.Wraith.IRobot;
import rdt.Wraith.Utils.MathUtils;

public final class BulletPrediction {
    public long TickPredictionWasGenerated;
    public long FiringTick;
    public long PredictionDeactivationTime;
    public long FirstPossibleInterceptTime;
    public long LastPossibleInterceptTime;
    public double Firepower;
    public double DamageDealt;
    public boolean FuturePrediction;
    public double Weight;
    private final int _maxTicks;
    private final int _accessMask;
    private PredictedPosition[] _predicctedPositions;

    public final PredictedPosition Read(int tick) {
        PredictedPosition position = this._predicctedPositions[tick & this._accessMask];
        assert (position.Tick == (long)tick) : "PredictedPosition tick is " + position.Tick + " accessing tick " + tick;
        return position;
    }

    public final PredictedPosition Write(long tick) {
        return this._predicctedPositions[(int)tick & this._accessMask];
    }

    public BulletPrediction(int maxTicks) {
        assert (MathUtils.IsPowerOfTwo(maxTicks));
        this._maxTicks = maxTicks;
        this._accessMask = this._maxTicks - 1;
        this._predicctedPositions = new PredictedPosition[maxTicks];
        for (int index = 0; index < maxTicks; ++index) {
            this._predicctedPositions[index] = new PredictedPosition();
        }
    }

    public final void UpdateInterceptTimes(IRobot robot) {
        double currentTargetX = robot.getX();
        double currentTargetY = robot.getY();
        long currentTick = robot.getTime();
        this.FirstPossibleInterceptTime = this.PredictionDeactivationTime + 1L;
        long mostRecentTickToCheck = Math.max(this.FiringTick, currentTick);
        this.LastPossibleInterceptTime = this.FiringTick;
        double robotHalfSizeSq = robot.getBotSizeMax() * 0.5 * (robot.getBotSizeMax() * 0.5);
        for (long tickToCheck = mostRecentTickToCheck; tickToCheck < this.PredictionDeactivationTime; ++tickToCheck) {
            long ticksMoved = tickToCheck - currentTick;
            PredictedPosition predictedBulletPosition = this.Read((int)tickToCheck);
            double deltaXFromCurrent = predictedBulletPosition.X - currentTargetX;
            double deltaYFromCurrent = predictedBulletPosition.Y - currentTargetY;
            double distanceToBulletSq = deltaXFromCurrent * deltaXFromCurrent + deltaYFromCurrent * deltaYFromCurrent;
            double distanceTargetMovedSq = 8.0 * (double)ticksMoved * (8.0 * (double)ticksMoved) + robotHalfSizeSq;
            if (!(distanceToBulletSq <= distanceTargetMovedSq)) continue;
            this.LastPossibleInterceptTime = tickToCheck;
            this.FirstPossibleInterceptTime = Math.min(this.FirstPossibleInterceptTime, tickToCheck);
        }
    }
}

