/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.EscapeEnvelope;

import rdt.Wraith.EscapeEnvelope.EscapeVector;
import rdt.Wraith.MEA.MEA;
import rdt.Wraith.Utils.FastOutsideOfBattlefield;
import rdt.Wraith.Utils.MathUtils;
import robocode.util.Utils;

public final class EscapeEnvelopeData {
    public double[] Distances = new double[32];

    public void Reset() {
        for (int vectorIndex = 0; vectorIndex < 32; ++vectorIndex) {
            this.Distances[vectorIndex] = 0.0;
        }
    }

    public void GetMEA(double sourceX, double sourceY, double targetX, double targetY, double targetRotationDirection, MEA outMEA) {
        double hotAngle = MathUtils.GetAngle(sourceX, sourceY, targetX, targetY);
        double minMEA = Math.PI;
        double maxMEA = -Math.PI;
        for (int vectorIndex = 0; vectorIndex < 32; ++vectorIndex) {
            double lineLength = this.Distances[vectorIndex];
            EscapeVector vector = EscapeVector.EscapeVectors[vectorIndex];
            double endX = targetX + vector.dX * lineLength;
            double endY = targetY + vector.dY * lineLength;
            double angle = MathUtils.GetAngle(sourceX, sourceY, endX, endY);
            double relativeAngle = Utils.normalRelativeAngle((double)(angle - hotAngle));
            minMEA = Math.min(minMEA, relativeAngle);
            maxMEA = Math.max(maxMEA, relativeAngle);
        }
        outMEA.ForwardRelative = targetRotationDirection >= 0.0 ? maxMEA : minMEA;
        outMEA.RearRelative = targetRotationDirection >= 0.0 ? minMEA : maxMEA;
    }

    public void CullOutsideOfBattlefield(double sourceX, double sourceY, FastOutsideOfBattlefield fastOutsideOfBattlefield) {
        for (int vectorIndex = 0; vectorIndex < 32; ++vectorIndex) {
            double lineLength = this.Distances[vectorIndex];
            EscapeVector escapeVector = EscapeVector.EscapeVectors[vectorIndex];
            double endX = sourceX + escapeVector.dX * lineLength;
            double endY = sourceY + escapeVector.dY * lineLength;
            if (!(fastOutsideOfBattlefield.Check(endX, endY) > 0.0)) continue;
            boolean bStillOutside = true;
            while (bStillOutside && lineLength >= 0.0) {
                endX = sourceX + escapeVector.dX * (lineLength -= 5.0);
                bStillOutside = fastOutsideOfBattlefield.Check(endX, endY = sourceY + escapeVector.dY * lineLength) > 0.0;
            }
            this.Distances[vectorIndex] = lineLength;
        }
    }

    public void ReduceForBotSize() {
        for (int vectorIndex = 0; vectorIndex < 32; ++vectorIndex) {
            double lineLength = this.Distances[vectorIndex];
            this.Distances[vectorIndex] = lineLength = Math.max(0.0, lineLength - 18.0);
        }
    }
}

