/*
 * Decompiled with CFR 0.152.
 */
package oog.mini;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class AlphaDragon
extends AdvancedRobot {
    static final Rectangle2D.Double fieldRect = new Rectangle2D.Double(0.0, 0.0, 800.0, 600.0);
    static ArrayList bullets;
    static double enemyEnergy;
    static Point2D.Double myPos;
    static Point2D.Double ePos;
    static ArrayList hitLog;
    static ArrayList waves;
    static ArrayList firingAngles;
    static double accel;

    static {
        hitLog = new ArrayList();
        firingAngles = new ArrayList();
    }

    public void run() {
        bullets = new ArrayList();
        waves = new ArrayList();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            if (this.getRadarTurnRemainingRadians() == 0.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            int i = 0;
            while (i < bullets.size()) {
                DoubleWave eb = (DoubleWave)bullets.get(i);
                if (((double)this.getTime() - eb.startTime) * eb.speed + eb.speed > myPos.distance(eb.eStartPos) + 100.0) {
                    bullets.remove(eb);
                }
                ++i;
            }
            if (hitLog.size() > 16) {
                hitLog.remove(hitLog.get(0));
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        int i;
        double d;
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        myPos = new Point2D.Double(this.getX(), this.getY());
        double currentDist = e.getDistance();
        ePos = AlphaDragon.project(myPos, currentDist, absBearing);
        DoubleWave eb = new DoubleWave();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
        eb.speed = 20.0 - 3.0 * (enemyEnergy - e.getEnergy());
        if (d >= 11.0 && eb.speed <= 19.7) {
            eb.eStartBearing = Utils.normalRelativeAngle((double)(absBearing + Math.PI));
            eb.startTime = this.getTime();
            eb.eStartPos = ePos;
            eb.myLatVel = this.getVelocity() * Math.sin(this.getHeadingRadians() - Utils.normalRelativeAngle((double)(absBearing + Math.PI)));
            eb.startDistance = currentDist;
            bullets.add(eb);
        }
        enemyEnergy = e.getEnergy();
        double bestRating = Double.POSITIVE_INFINITY;
        double turn = 0.0;
        while (turn < Math.PI * 2) {
            Point2D.Double movePoint = AlphaDragon.project(myPos, 8.0, turn);
            double rating = 0.0;
            rating = 1.0 / movePoint.distance(ePos);
            if (this.closest(false) != null) {
                double closestHit = Double.POSITIVE_INFINITY;
                double dodgeAngle = 0.0;
                i = 0;
                while (i < hitLog.size()) {
                    DoubleWave hit = (DoubleWave)hitLog.get(i);
                    double hitRating = 2.0 * Math.pow(Math.abs(eb.myLatVel - hit.myLatVel) / 16.0, 2.0) + Math.pow(Math.abs(eb.startDistance - hit.startDistance) / 1000.0, 2.0);
                    if (hitRating < closestHit) {
                        closestHit = hitRating;
                        dodgeAngle = hit.hitAngle;
                    }
                    ++i;
                }
                eb = this.closest(false);
                rating = 1.0 / Math.pow(movePoint.distance(AlphaDragon.project(eb.eStartPos, movePoint.distance(eb.eStartPos), eb.eStartBearing + dodgeAngle)), 2.0);
            }
            if (rating < bestRating && fieldRect.contains(AlphaDragon.project(myPos, 160.0, turn))) {
                bestRating = rating;
                int dir = Math.abs(turn - this.getHeadingRadians()) < 1.5707963267948966 ? 1 : -1;
                this.setAhead((double)dir * Double.POSITIVE_INFINITY);
                this.setTurnRightRadians(Utils.normalRelativeAngle((double)(turn + (dir == 1 ? 0.0 : Math.PI) - this.getHeadingRadians())));
            }
            turn += 0.19634954084936207;
        }
        eb = new DoubleWave();
        double d2 = accel;
        accel = e.getVelocity();
        double acSeg = d2 - accel;
        double adSeg = e.getVelocity() * Math.cos(e.getHeadingRadians() - absBearing);
        double velSeg = e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing);
        double firePower = Math.max(0.1, Math.min(3.0, e.getDistance() > 100.0 ? Math.min(Math.min(e.getEnergy() / 4.0, this.getEnergy() / 15.0), 2.0) : 3.0));
        if (this.getGunHeat() == 0.0 && this.getEnergy() > 0.0) {
            eb.startTime = this.getTime();
            eb.eLatVel = velSeg;
            eb.myStartPos = myPos;
            eb.myStartBearing = absBearing;
            eb.startDistance = currentDist;
            eb.eAdVel = adSeg;
            eb.eAcVel = acSeg;
            eb.speed = 20.0 - 3.0 * firePower;
            waves.add(eb);
        }
        i = 0;
        while (i < waves.size()) {
            eb = (DoubleWave)waves.get(i);
            if (((double)this.getTime() - eb.startTime) * eb.speed >= Point2D.distance(AlphaDragon.ePos.x, AlphaDragon.ePos.y, eb.myStartPos.x, eb.myStartPos.y)) {
                eb.hitAngle = Utils.normalRelativeAngle((double)Utils.normalAbsoluteAngle((double)(Math.atan2(AlphaDragon.ePos.x - eb.myStartPos.x, AlphaDragon.ePos.y - eb.myStartPos.y) - eb.myStartBearing))) * eb.speed;
                firingAngles.add(eb);
                waves.remove(eb);
            }
            ++i;
        }
        double aim = 0.0;
        bestRating = Double.POSITIVE_INFINITY;
        i = 0;
        while (i < firingAngles.size()) {
            eb = (DoubleWave)firingAngles.get(i);
            currentDist = 2.0 * Math.pow(velSeg - eb.eLatVel, 2.0) + Math.pow(adSeg - eb.eAdVel, 2.0) + Math.pow((eb.startDistance - e.getDistance()) / 200.0, 2.0) + 2.0 * Math.pow(acSeg - eb.eAcVel, 2.0);
            if (currentDist < bestRating) {
                bestRating = currentDist;
                aim = eb.hitAngle / (20.0 - 3.0 * firePower);
            }
            ++i;
        }
        this.setFire(firePower);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians())) + aim);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        try {
            this.closest((boolean)true).hitAngle = Utils.normalRelativeAngle((double)(Utils.normalAbsoluteAngle((double)Math.atan2(this.getX() - this.closest((boolean)true).eStartPos.x, this.getY() - this.closest((boolean)true).eStartPos.y)) - this.closest((boolean)true).eStartBearing));
            hitLog.add(this.closest(true));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DoubleWave closest(boolean hit) {
        DoubleWave closest = null;
        double bestDist = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < bullets.size()) {
            DoubleWave eb = (DoubleWave)bullets.get(i);
            if (((double)this.getTime() - eb.startTime) * eb.speed + eb.speed > bestDist && (hit || ((double)this.getTime() - eb.startTime) * eb.speed + eb.speed < myPos.distance(ePos))) {
                bestDist = ((double)this.getTime() - eb.startTime) * eb.speed + eb.speed;
                closest = eb;
            }
            ++i;
        }
        return closest;
    }

    public static Point2D.Double project(Point2D.Double startPos, double dist, double heading) {
        return new Point2D.Double(startPos.x + dist * Math.sin(heading), startPos.y + dist * Math.cos(heading));
    }

    public static class DoubleWave {
        Point2D.Double myStartPos;
        Point2D.Double eStartPos;
        double startDistance;
        double myStartBearing;
        double eStartBearing;
        double speed;
        double startTime;
        double myLatVel;
        double eLatVel;
        double eAdVel;
        double eAcVel;
        double wallDist;
        double hitAngle;
    }
}

