/*
 * Decompiled with CFR 0.152.
 */
package bigpete;

import bigpete.AdvancedMovementRobot;
import bigpete.EnemyRobot;
import bigpete.EnemyRobotList;
import bigpete.Movement;
import bigpete.Scanner;
import bigpete.Targeting;
import bigpete.VirtualBulletList;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitRobotEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class Stewie
extends AdvancedMovementRobot {
    final double Pi = Math.PI;
    final double Pi2 = Math.PI * 2;
    EnemyRobotList targets;
    Targeting targeting;
    Movement movement;
    Scanner radar;
    VirtualBulletList bullets;
    private Point2D current_position;

    public void run() {
        this.setColors(new Color(130, 150, 200), new Color(250, 250, 250), new Color(250, 160, 0));
        this.current_position = new Point2D.Double(this.getX(), this.getY());
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.targets = new EnemyRobotList();
        this.targeting = new Targeting(this, this.targets);
        this.bullets = new VirtualBulletList(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.movement = new Movement(this, this.targets, this.bullets);
        this.radar = new Scanner(this, this.targets);
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        while (true) {
            this.bullets.update(this.getTime(), this.currentPosition());
            this.movement.move();
            this.execute();
        }
    }

    public Point2D currentPosition() {
        this.current_position.setLocation(this.getX(), this.getY());
        return this.current_position;
    }

    public void onCustomEvent(CustomEvent event) {
        if (event.getCondition() instanceof RadarTurnCompleteCondition) {
            this.radar.radarStopped();
        }
    }

    public void onScannedRobot(ScannedRobotEvent robot) {
        this.targets.update(robot, this.getHeadingRadians(), this.current_position);
        EnemyRobot tmp_robot = this.targets.getRobot(robot.getName());
        double energy_change = tmp_robot.getEnergyChange();
        if (energy_change >= 0.1 && energy_change <= 3.0 && energy_change != tmp_robot.getVelocity() / 2.0 - 1.0) {
            double heading = Math.PI + tmp_robot.getRelativeBearing();
            double velocity = 20.0 - 3.0 * energy_change;
            this.bullets.addBullet(velocity, heading, tmp_robot.getPosition(), this.current_position, this.getTime());
        }
        if (this.targeting.bestTarget() != null && this.targeting.bestTarget().getName().equals(robot.getName())) {
            this.targeting.shoot();
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        this.targets.updateEnergy(event.getName(), event.getEnergy());
    }

    public void onHitRobot(HitRobotEvent event) {
        this.targets.updateEnergy(event.getName(), event.getEnergy());
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.targets.remove(event.getName());
    }

    public void onWin(WinEvent event) {
        this.setTurnRadarLeft(Double.MAX_VALUE);
        this.setTurnGunRight(Double.MAX_VALUE);
        this.turnLeft(Double.MAX_VALUE);
    }
}

