/*
 * Decompiled with CFR 0.152.
 */
package rz;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import rz.stuff.MicroWave;

public class Artist
extends AdvancedRobot {
    private static final int DIR_FAC = 15;
    private static final int MOVEMENT_SHIFT = 30;
    private static final int MOVEMENT_SIZE = 8;
    private static int circleDir = 1;
    private static int[][][] hitFactors = new int[3][5][50];
    private static ArrayList eWaves;
    private static double timeToImpact;
    private static double targetEnergy;

    public void run() {
        eWaves = new ArrayList();
        this.turnRadarRight(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double d;
        MicroWave w = new MicroWave();
        double absBearing = this.getHeadingRadians() + e.getBearingRadians();
        double dist = e.getDistance();
        w.gunLocation = this.calcPoint(absBearing, dist);
        double d2 = targetEnergy;
        targetEnergy = e.getEnergy();
        double power = d2 - targetEnergy;
        if (0.0 < d && power <= (double)3) {
            eWaves.add(w);
            w.absBearing = absBearing + Math.PI;
            w.bulletVelocity = 20.0 - (double)3 * power;
            w.bearingDirection = (double)(this.getVelocity() * Math.sin(e.getBearingRadians()) < -0.01 ? -1 : 1) * Math.asin(8.0 / w.bulletVelocity) / 15.0;
            w.shotTime = this.getTime() - (long)2;
            w.factors = hitFactors[(int)(Math.abs(this.getVelocity()) / (double)3)][(int)(dist / 200.0)];
        }
        if (this.getEnergy() > (double)2) {
            this.setFire(Math.min(1100.0 / dist, Math.min(this.getEnergy(), targetEnergy) / (double)4));
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians() + Math.random() * e.getVelocity() / 11.0 * Math.sin(e.getHeadingRadians() - absBearing))));
        this.setTurnRadarLeft(this.getRadarTurnRemaining());
        double val = 2;
        while (!new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0).contains(this.calcPoint(power = absBearing + (double)circleDir * (val -= 0.02), 160.0))) {
        }
        try {
            if (dist > 100.0 && (this.getValue(w = this.getClosestWave(false), circleDir) < this.getValue(w, -circleDir) || val < 0.7)) {
                circleDir = -circleDir;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.setAhead(Math.cos(power -= this.getHeadingRadians()) * 100.0);
        this.setTurnRightRadians(Math.tan(power));
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.getClosestWave(true).getValue(e.getHeadingRadians(), 1);
    }

    private final double getValue(MicroWave w, int dir) {
        double dummy = 0.0;
        int b = -30;
        do {
            dummy += w.getValue(Math.atan2(this.getX() - w.gunLocation.x, this.getY() - w.gunLocation.y) + (timeToImpact * 8.0 * (double)dir + (double)b) / this.distToWave(w), 0);
        } while ((b += 5) <= 30);
        return dummy;
    }

    private final MicroWave getClosestWave(boolean checkPassedWaves) {
        MicroWave closestWave = null;
        double closestDist = 10000.0;
        int i = 0;
        try {
            while (true) {
                double d;
                MicroWave wave = (MicroWave)eWaves.get(i++);
                double dist = (double)(this.getTime() - wave.shotTime) - this.distToWave(wave) / wave.bulletVelocity;
                if (!(Math.abs(d) < closestDist) || !checkPassedWaves && !(dist < 0.0)) continue;
                closestDist = Math.abs(dist);
                closestWave = wave;
            }
        }
        catch (Exception ex) {
            timeToImpact = Math.min(8.0, closestDist);
            return closestWave;
        }
    }

    private final double distToWave(MicroWave w) {
        return w.gunLocation.distance(this.getX(), this.getY());
    }

    private final Point2D.Double calcPoint(double ang, double dist) {
        return new Point2D.Double(this.getX() + dist * Math.sin(ang), this.getY() + dist * Math.cos(ang));
    }
}

