/*
 * Decompiled with CFR 0.152.
 */
package bjl;

import bjl.BattleField;
import bjl.Utils;
import java.io.Serializable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Point
implements Serializable {
    public double x;
    public double y;

    public static Point makePoint(Point p, double heading, double dist) {
        return new Point(p.x + Math.sin(Math.toRadians(heading)) * dist, p.y + Math.cos(Math.toRadians(heading)) * dist);
    }

    public double dist(Point other) {
        return Math.sqrt((this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y));
    }

    public double dist2(Point other) {
        return (this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y);
    }

    public double angleTo(Point other) {
        return Utils.normalHeading(90.0 - Math.toDegrees(Math.atan2(other.y - this.y, other.x - this.x)));
    }

    public boolean isOutsideArena() {
        return this.x < 0.0 || this.x > BattleField.getWidth() || this.y < 0.0 || this.y > BattleField.getHeight();
    }

    public String toString() {
        return "(" + this.x + ',' + this.y + ')';
    }

    private final /* synthetic */ void this() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Point(double x, double y) {
        this.this();
        this.x = x;
        this.y = y;
    }

    public Point(Point p) {
        this.this();
        this.x = p.x;
        this.y = p.y;
    }
}

