/*
 * Decompiled with CFR 0.152.
 */
package bjl.radar;

import bjl.BattleField;
import bjl.Enemy;
import bjl.SuperBlip;
import bjl.Utils;
import bjl.radar.RadarStrategy;

public class ScanTarget
extends RadarStrategy {
    public String toString() {
        return "ScanTarget";
    }

    public double Process(Enemy focus, boolean isCurStrategy) {
        if (focus == null) {
            return 0.0;
        }
        SuperBlip me = BattleField.getMe();
        double targetHeading = 90.0 - Math.toDegrees(Math.atan2(focus.getLastPosition().y - me.pos.y, focus.getLastPosition().x - me.pos.x));
        double angle = Utils.normalRelativeAngle(targetHeading - me.radarHeading);
        angle = angle >= 0.0 ? (angle += 15.0) : (angle -= 15.0);
        angle = Utils.normalRelativeAngle(angle);
        return angle;
    }

    public double getUsefulness(Enemy focus) {
        if (focus == null || focus.getLastBlip().time < BattleField.getTime() - 40L || focus.getLastBlip().roundnum != BattleField.getRound()) {
            return 0.0;
        }
        return 10.0;
    }
}

