/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.bot;

import pedersen.debug.Debug;
import pedersen.debug.Debuggable;

public class BearingOffsetRange
implements Debuggable {
    private final double a;
    private final double b;

    public BearingOffsetRange(double _a, double _b) {
        this.a = _a;
        this.b = _b;
    }

    public double min() {
        return Math.min(this.a, this.b);
    }

    public double max() {
        return Math.max(this.a, this.b);
    }

    public double getFactoredBearingOffset(double factor) {
        return factor * (factor < 0.0 ? -this.min() : this.max());
    }

    public double getRawFactoredBearingOffset(double factor) {
        return factor * (this.max() - this.min()) + this.min();
    }

    public void debug() {
        Debug.debug(this.toString());
    }

    public String toString() {
        return "BearingOffsetRange: ( " + this.a + ", " + this.b + " )";
    }
}

