/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.Position;
import pa3k.RobotModule;
import robocode.AdvancedRobot;
import robocode.Robot;

public class SelfTracking
extends RobotModule {
    protected int history;
    protected int index;
    protected Position[] lastPosition;
    protected double[] lastVelocity;
    protected double[] lastHeading;
    protected int energyIndex;
    protected long[] lastEnergyDropTime;
    protected double lastEnergy;

    public SelfTracking(AdvancedRobot advancedRobot, int n) {
        super(advancedRobot);
        this.history = n;
        this.index = 0;
        this.lastPosition = new Position[n];
        this.lastVelocity = new double[n];
        this.lastHeading = new double[n];
        this.lastEnergyDropTime = new long[n];
        this.energyIndex = 0;
    }

    @Override
    public void init() {
        for (int i = 0; i < this.history; ++i) {
            this.lastPosition[i] = new Position((Robot)this.robot);
            this.lastVelocity[i] = this.robot.getVelocity();
            this.lastHeading[i] = this.robot.getHeadingRadians();
        }
        this.lastEnergy = this.robot.getEnergy();
    }

    @Override
    public void turn() {
        ++this.index;
        this.index %= this.history;
        this.lastPosition[this.index] = new Position((Robot)this.robot);
        this.lastVelocity[this.index] = this.robot.getVelocity();
        this.lastHeading[this.index] = this.robot.getHeadingRadians();
        double d = this.robot.getEnergy();
        if (d < this.lastEnergy) {
            ++this.energyIndex;
            this.energyIndex %= this.history;
            this.lastEnergyDropTime[this.energyIndex] = this.robot.getTime();
        }
        this.lastEnergy = d;
    }

    public Position getLastPosition(int n) throws Exception {
        return this.lastPosition[this.getLastIndex(n)];
    }

    public double getLastVelocity(int n) throws Exception {
        return this.lastVelocity[this.getLastIndex(n)];
    }

    public double getLastHeading(int n) throws Exception {
        return this.lastHeading[this.getLastIndex(n)];
    }

    private int getLastIndex(int n) throws Exception {
        if (n > this.history) {
            throw new Exception();
        }
        return (this.index + this.history - n) % this.history;
    }

    public long lastEnergyDrop(long l) {
        return l - this.lastEnergyDropTime[this.energyIndex];
    }
}

