/*
 * Decompiled with CFR 0.152.
 */
package barontrozo;

import barontrozo.BaronTrozo;
import barontrozo.BulletFollower;
import barontrozo.SmartDistanceFunction;
import barontrozo.StatusBuilder;
import barontrozo.dataStructures.trees.KdTree;
import barontrozo.dataStructures.trees.NearestNeighborIterator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import robocode.util.Utils;

public class PredictorHistory {
    double minLimit_;
    KdTree<Double> lastFiredPosition_ = new KdTree(StatusBuilder.GetDimension());
    KdTree<Double> lastMovePosition_ = new KdTree(StatusBuilder.GetDimension());
    KdTree<Double> lastVirtualPosition_ = new KdTree(StatusBuilder.GetDimension());
    SmartDistanceFunction distFunc_ = new SmartDistanceFunction(StatusBuilder.GetDimension());
    double[] danger_;
    double minDanger_;
    double maxDanger_;
    List<Point2D.Double> posiblePositions_;
    double fieldWidth_;
    double fieldHeight_;
    int nextWaveSlots_ = 10;
    double[] nextwave_ = new double[this.nextWaveSlots_];
    double turnsToReach_;

    public void SetLimit(double fieldWidth, double fieldHeight, double minLimit) {
        this.fieldWidth_ = fieldWidth;
        this.fieldHeight_ = fieldHeight;
        this.minLimit_ = minLimit;
    }

    public void AddMoveAvoidResult(double val, double[] status) {
        this.lastMovePosition_.addPoint(status, (Object)new Double(val));
    }

    public void AddResult(double val, double[] status) {
        this.lastFiredPosition_.addPoint(status, (Object)new Double(val));
    }

    public void AddVirtualResult(double val, double[] status) {
        this.lastVirtualPosition_.addPoint(status, (Object)new Double(val));
    }

    public double ChooseAngleToFire(BulletFollower bulletFollower, double[] status) {
        double factor;
        int ind;
        double indD;
        double val;
        Double doubleVal;
        double angleBegin = bulletFollower.angleBegin_;
        double angleArc = bulletFollower.angleArc_;
        double distance = bulletFollower.distance_;
        int unitsCeil = ((int)Math.round(Math.ceil(angleArc * distance / (this.minLimit_ * 2.0))) + 1) * 10;
        double res = 1.0 / ((double)unitsCeil * 2.0);
        double[] stats = new double[unitsCeil + 1];
        NearestNeighborIterator<Double> iterator = this.lastFiredPosition_.getNearestNeighborIterator(status, BaronTrozo.conf_.firePostionNs_, this.distFunc_);
        while (iterator.hasNext()) {
            doubleVal = iterator.next();
            val = StatusBuilder.GetAbsoluteValueRelativeToAngle(bulletFollower, doubleVal);
            if (val < res) {
                stats[0] = stats[0] + 1.0;
                continue;
            }
            if (val > 1.0 - res) {
                int n = unitsCeil;
                stats[n] = stats[n] + 1.0;
                continue;
            }
            indD = (val - res) / (res * 2.0);
            ind = (int)Math.round(Math.floor(indD + 1.0));
            factor = SmartDistanceFunction.GetMaxDistance() - iterator.distance();
            int n = ind;
            stats[n] = stats[n] + Math.pow(factor, BaronTrozo.conf_.firePostionPow_) * BaronTrozo.conf_.firePostionFactor_;
        }
        iterator = this.lastVirtualPosition_.getNearestNeighborIterator(status, BaronTrozo.conf_.fireVirtualPostionNs_, this.distFunc_);
        while (iterator.hasNext()) {
            doubleVal = iterator.next();
            val = StatusBuilder.GetAbsoluteValueRelativeToAngle(bulletFollower, doubleVal);
            if (val < res) {
                stats[0] = stats[0] + 1.0;
                continue;
            }
            if (val > 1.0 - res) {
                int n = unitsCeil;
                stats[n] = stats[n] + 1.0;
                continue;
            }
            indD = (val - res) / (res * 2.0);
            ind = (int)Math.round(Math.floor(indD + 1.0));
            factor = SmartDistanceFunction.GetMaxDistance() - iterator.distance();
            int n = ind;
            stats[n] = stats[n] + Math.pow(factor, BaronTrozo.conf_.fireVirtualPostionPow_) * BaronTrozo.conf_.fireVirtualPostionFactor_;
        }
        double total = 0.0;
        int i = 0;
        while (i < unitsCeil + 1) {
            int n = i;
            stats[n] = stats[n] * Math.pow(stats[i], BaronTrozo.conf_.fireCellPow_);
            total += stats[i];
            ++i;
        }
        if (total == 0.0) {
            return Utils.normalAbsoluteAngle((double)(angleBegin + angleArc * Utils.getRandom().nextDouble()));
        }
        double ran = Utils.getRandom().nextDouble() * total;
        total = 0.0;
        int i2 = 0;
        while (i2 < unitsCeil + 1) {
            if (ran <= (total += stats[i2])) {
                return Utils.normalAbsoluteAngle((double)(angleBegin + angleArc / (double)unitsCeil * (double)i2));
            }
            ++i2;
        }
        return Utils.normalAbsoluteAngle((double)(angleBegin + angleArc * Utils.getRandom().nextDouble()));
    }

    public Point2D.Double ChooseSavePlace(List<Point2D.Double> posiblePositions, List<Integer> positionsTurns, BulletFollower bulletFollower, BulletFollower secondayBulletFollower, Point2D.Double statregicPoint, long turnNow, double idealDist) {
        double factor;
        int i;
        double val;
        int size = posiblePositions.size();
        double angleBegin = bulletFollower.angleBegin_;
        double angleArc = bulletFollower.angleArc_;
        double[] rangeMin = new double[size];
        double[] rangeMax = new double[size];
        this.posiblePositions_ = posiblePositions;
        this.danger_ = new double[size];
        this.maxDanger_ = -1.7976931348623157E308;
        this.minDanger_ = Double.MAX_VALUE;
        int savestPos = 0;
        double modifier = this.minLimit_ / (angleArc * bulletFollower.distance_);
        int i2 = 0;
        while (i2 < size) {
            Point2D.Double point = posiblePositions.get(i2);
            double angle = Math.atan2(point.getX() - bulletFollower.firePos_.getX(), point.getY() - bulletFollower.firePos_.getY());
            angle = Utils.normalAbsoluteAngle((double)(angle - angleBegin)) / angleArc;
            rangeMin[i2] = angle - modifier;
            rangeMax[i2] = angle + modifier;
            this.danger_[i2] = 0.0;
            if (bulletFollower.IsValuePostionOnShadow(angle)) {
                int n = i2;
                this.danger_[n] = this.danger_[n] - BaronTrozo.conf_.sadowOne_;
            }
            if (bulletFollower.IsValuePostionOnShadow(rangeMin[i2])) {
                int n = i2;
                this.danger_[n] = this.danger_[n] - BaronTrozo.conf_.sadowOne_;
            }
            if (bulletFollower.IsValuePostionOnShadow(rangeMax[i2])) {
                int n = i2;
                this.danger_[n] = this.danger_[n] - BaronTrozo.conf_.sadowOne_;
            }
            if (this.danger_[i2] == -BaronTrozo.conf_.sadowOne_ * 2.0) {
                int n = i2;
                this.danger_[n] = this.danger_[n] - BaronTrozo.conf_.sadowTwo_;
            } else if (this.danger_[i2] == -BaronTrozo.conf_.sadowOne_ * 3.0) {
                int n = i2;
                this.danger_[n] = this.danger_[n] - BaronTrozo.conf_.sadowThree_;
            }
            double dist = point.distance(bulletFollower.firePos_);
            double distObj = Math.abs(idealDist - dist);
            int n = i2;
            this.danger_[n] = this.danger_[n] + Math.pow(Math.abs(point.getX() - statregicPoint.getX()) / this.fieldWidth_ + Math.abs(point.getY() - statregicPoint.getY()) / this.fieldHeight_, BaronTrozo.conf_.strategigPow_) * BaronTrozo.conf_.strategigFactor_;
            double val2 = Math.pow(distObj, BaronTrozo.conf_.keepDistancePow_) * BaronTrozo.conf_.keepDistanceFactor_;
            if (dist < idealDist / 2.0) {
                val2 *= Math.pow(distObj, BaronTrozo.conf_.keepLessHalfDistancePow_) * BaronTrozo.conf_.keepLessHalfDistanceFactor_;
            }
            int n2 = i2++;
            this.danger_[n2] = this.danger_[n2] + val2;
        }
        double[] status = StatusBuilder.GetStatusArrayFromBulletFollower(bulletFollower);
        NearestNeighborIterator<Double> iterator = this.lastFiredPosition_.getNearestNeighborIterator(status, BaronTrozo.conf_.enemyHitPostionNs_, this.distFunc_);
        while (iterator.hasNext()) {
            Double doubleVal = iterator.next();
            val = StatusBuilder.GetAbsoluteValueRelativeToAngle(bulletFollower, doubleVal);
            if (bulletFollower.IsValuePostionOnShadow(val)) continue;
            i = 0;
            while (i < size) {
                if (val >= rangeMin[i] && val <= rangeMax[i]) {
                    factor = SmartDistanceFunction.GetMaxDistance() - iterator.distance();
                    int n = i;
                    this.danger_[n] = this.danger_[n] + Math.pow(factor, BaronTrozo.conf_.enemyHitPostionPow_) * BaronTrozo.conf_.enemyHitPostionFactor_;
                }
                ++i;
            }
        }
        iterator = this.lastMovePosition_.getNearestNeighborIterator(status, BaronTrozo.conf_.enemyViewPostionNs_, this.distFunc_);
        while (iterator.hasNext()) {
            Double doubleVal = iterator.next();
            val = StatusBuilder.GetAbsoluteValueRelativeToAngle(bulletFollower, doubleVal);
            if (bulletFollower.IsValuePostionOnShadow(val)) continue;
            i = 0;
            while (i < size) {
                if (val >= rangeMin[i] && val <= rangeMax[i]) {
                    factor = SmartDistanceFunction.GetMaxDistance() - iterator.distance();
                    int n = i;
                    this.danger_[n] = this.danger_[n] + Math.pow(factor, BaronTrozo.conf_.enemyViewPostionPow_) * BaronTrozo.conf_.enemyViewPostionFactor_;
                }
                ++i;
            }
        }
        iterator = this.lastVirtualPosition_.getNearestNeighborIterator(status, BaronTrozo.conf_.enemyVirtualHitPostionNs_, this.distFunc_);
        while (iterator.hasNext()) {
            Double doubleVal = iterator.next();
            val = StatusBuilder.GetAbsoluteValueRelativeToAngle(bulletFollower, doubleVal);
            if (bulletFollower.IsValuePostionOnShadow(val)) continue;
            i = 0;
            while (i < size) {
                if (val >= rangeMin[i] && val <= rangeMax[i]) {
                    factor = SmartDistanceFunction.GetMaxDistance() - iterator.distance();
                    int n = i;
                    this.danger_[n] = this.danger_[n] + Math.pow(factor, BaronTrozo.conf_.enemyVirtualHitPostionPow_) * BaronTrozo.conf_.enemyVirtualHitPostionFactor_;
                }
                ++i;
            }
        }
        if (secondayBulletFollower != null) {
            int i3 = 0;
            while (i3 < this.nextWaveSlots_) {
                this.nextwave_[i3] = 0.0;
                ++i3;
            }
            double[] status2 = StatusBuilder.GetStatusArrayFromBulletFollower(secondayBulletFollower);
            iterator = this.lastFiredPosition_.getNearestNeighborIterator(status2, BaronTrozo.conf_.enemySecondHitPostionNs_, this.distFunc_);
            while (iterator.hasNext()) {
                Double doubleVal = iterator.next();
                double val3 = StatusBuilder.GetAbsoluteValueRelativeToAngle(secondayBulletFollower, doubleVal);
                if (secondayBulletFollower.IsValuePostionOnShadow(val3)) continue;
                int index = (int)Math.round(Math.floor(val3 * (double)this.nextWaveSlots_));
                double factor2 = SmartDistanceFunction.GetMaxDistance() - iterator.distance();
                double valc = Math.pow(factor2, BaronTrozo.conf_.enemySecondHitPostionPow_) * BaronTrozo.conf_.enemySecondHitPostionFactor_;
                if (index < 0) {
                    this.nextwave_[0] = this.nextwave_[0] + valc;
                    continue;
                }
                if (index > this.nextWaveSlots_ - 1) {
                    int n = this.nextWaveSlots_ - 1;
                    this.nextwave_[n] = this.nextwave_[n] + valc;
                    continue;
                }
                int n = index;
                this.nextwave_[n] = this.nextwave_[n] + valc;
            }
            double dist = posiblePositions.get(0).distance(secondayBulletFollower.firePos_);
            double elementTurns = dist * secondayBulletFollower.angleArc_ / (double)this.nextWaveSlots_ / 4.0;
            double turnToReach = dist / secondayBulletFollower.bulletSpeed_;
            turnToReach -= (double)(turnNow - secondayBulletFollower.turnInitial_);
            int i4 = 0;
            while (i4 < size) {
                Point2D.Double point = posiblePositions.get(i4);
                double turnToReachThis = turnToReach - (double)positionsTurns.get(i4).intValue();
                int nums = 0;
                if (turnToReachThis > 0.0) {
                    nums = (int)Math.round(turnToReachThis / elementTurns);
                }
                double angle = Math.atan2(point.getX() - secondayBulletFollower.firePos_.getX(), point.getY() - secondayBulletFollower.firePos_.getY());
                angle = Utils.normalAbsoluteAngle((double)(angle - secondayBulletFollower.angleBegin_));
                double valPos = angle / secondayBulletFollower.angleArc_;
                int index = (int)Math.round(Math.floor(valPos * (double)this.nextWaveSlots_));
                int i1 = index - nums;
                int i22 = index + 1 + nums;
                if (i1 <= 0) {
                    i1 = 0;
                }
                if (i22 > this.nextWaveSlots_) {
                    i22 = this.nextWaveSlots_;
                }
                double minValInc = Double.MAX_VALUE;
                int j = i1;
                while (j < i22) {
                    if (this.nextwave_[j] < minValInc) {
                        minValInc = this.nextwave_[j];
                    }
                    ++j;
                }
                int n = i4++;
                this.danger_[n] = this.danger_[n] + minValInc;
            }
        }
        int i5 = 0;
        while (i5 < size) {
            if (this.danger_[i5] > this.maxDanger_) {
                this.maxDanger_ = this.danger_[i5];
            }
            if (this.danger_[i5] < this.minDanger_) {
                this.minDanger_ = this.danger_[i5];
                savestPos = i5;
            }
            ++i5;
        }
        Point2D.Double point = posiblePositions.get(savestPos);
        this.turnsToReach_ = positionsTurns.get(savestPos).intValue();
        return new Point2D.Double(point.getX(), point.getY());
    }

    public void onPaint(Graphics2D g) {
        if (this.posiblePositions_ != null) {
            int size = this.posiblePositions_.size();
            int i = 0;
            while (i < size) {
                float dang = 0.0f;
                if (this.maxDanger_ > this.minDanger_) {
                    dang = (float)((this.danger_[i] - this.minDanger_) / (this.maxDanger_ - this.minDanger_));
                }
                g.setColor(new Color(dang, 1.0f - dang, 0.0f));
                g.drawRect((int)(this.posiblePositions_.get(i).getX() - 1.0), (int)(this.posiblePositions_.get(i).getY() - 1.0), 2, 2);
                ++i;
            }
        }
    }

    public void PrintStatus(double[] status) {
        int i = 0;
        while (i < 7) {
            System.out.printf("%f ", status[i]);
            ++i;
        }
        System.out.printf("\n", new Object[0]);
    }
}

