/*
 * Decompiled with CFR 0.152.
 */
package tlp;

import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class ThreeLeggedPig
extends AdvancedRobot {
    static int direction = 7;
    static int turnDirection = 1;
    static double bulletVelocity = 0.0;
    static double distance;
    static int ram;

    public void run() {
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        if (ram == 1) {
            this.turnRight(10 * turnDirection);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        distance = e.getDistance();
        String name = e.getName();
        if (this.getOthers() < 2 && name.contains("sample.SpinBot") && distance > 200.0) {
            this.turnRight(e.getBearing());
            this.ahead(distance);
        }
        if (distance < 30.0) {
            ram = 1;
            turnDirection = e.getBearing() >= 0.0 ? 1 : -1;
            this.turnRight(e.getBearing());
            this.ahead(distance + (double)5);
            this.scan();
        }
        if (ram == 0) {
            double v = 0.6 * bulletVelocity / distance;
            if (Math.random() > Math.pow(v, v)) {
                direction = -direction;
            }
            this.setAhead(direction * 15);
            this.setTurnRight(this.normalizeDegrees(e.getBearing() + 90.0 - (double)direction));
            double enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getGunHeadingRadians() + e.getVelocity() * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing) / 13.0)));
            if (distance < 175.0) {
                this.fire(3);
            } else if (distance < 215.0) {
                this.fire(2.6);
            } else if (distance < 250.0) {
                this.fire(2.2);
            } else if (distance < 350.0) {
                this.fire(1.4);
            } else if (distance < 450.0) {
                this.fire(0.8);
            }
            this.setTurnRadarLeftRadians(this.getRadarTurnRemaining());
        }
    }

    public void onHitWall(HitWallEvent e) {
        ram = 0;
        direction = -direction;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        bulletVelocity = e.getVelocity();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        ram = 0;
    }

    double normalizeDegrees(double angle) {
        return Math.toDegrees(Utils.normalRelativeAngle((double)Math.toRadians(angle)));
    }

    static {
        ram = 0;
    }
}

