/*
 * Decompiled with CFR 0.152.
 */
package rdm.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import rdm.state.StateCollector;
import rdm.state.StateCollectorImplKt;
import rdm.state.entities.AggregateState;
import rdm.state.entities.EnemyState;
import rdm.state.entities.InstantState;
import rdm.state.entities.State;
import rdm.state.entities.WorldState;
import rdm.state.utils.MinMaxCollector;
import rdm.state.utils.MovingAverage;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00042\u0006\u0010 \u001a\u00020\u001eH\u0002J\b\u0010!\u001a\u00020\u0018H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lrdm/state/StateCollectorImpl;", "Lrdm/state/StateCollector;", "()V", "absGunRelatedEnemyBearingAverages", "", "Lrdm/state/utils/MovingAverage;", "absGunRelatedEnemyHeadingAverages", "distanceAverages", "enemyRangeX", "Lrdm/state/utils/MinMaxCollector;", "enemyRangeXAverage", "enemyRangeY", "enemyRangeYAverage", "gunRelatedEnemyBearingAverages", "gunRelatedEnemyHeadingAverages", "normalizedDistanceFromCenterAverages", "normalizedXAverages", "normalizedYAverages", "velocityAverages", "collect", "Lrdm/state/entities/State;", "instant", "Lrdm/state/entities/InstantState;", "collectEnemyPosition", "", "enemy", "Lrdm/state/entities/EnemyState;", "extractBooleans", "", "extractFloats", "", "extractRanges", "worldArea", "onRoundStart", "onRoundStop", "Commons"})
public final class StateCollectorImpl
implements StateCollector {
    private static final List<MovingAverage> velocityAverages;
    private static final List<MovingAverage> distanceAverages;
    private static final List<MovingAverage> normalizedXAverages;
    private static final List<MovingAverage> normalizedYAverages;
    private static final List<MovingAverage> normalizedDistanceFromCenterAverages;
    private static final List<MovingAverage> gunRelatedEnemyBearingAverages;
    private static final List<MovingAverage> gunRelatedEnemyHeadingAverages;
    private static final List<MovingAverage> absGunRelatedEnemyBearingAverages;
    private static final List<MovingAverage> absGunRelatedEnemyHeadingAverages;
    private static final MinMaxCollector enemyRangeX;
    private static final MinMaxCollector enemyRangeY;
    private static final MovingAverage enemyRangeXAverage;
    private static final MovingAverage enemyRangeYAverage;
    public static final StateCollectorImpl INSTANCE;

    @Override
    public void onRoundStart() {
        double d = enemyRangeX.getRange();
        if (!Double.isNaN(d)) {
            enemyRangeXAverage.add(enemyRangeX.getRange());
        }
        if (!Double.isNaN(d = enemyRangeY.getRange())) {
            enemyRangeYAverage.add(enemyRangeY.getRange());
        }
        enemyRangeX.clear();
        enemyRangeY.clear();
    }

    @Override
    public void onRoundStop() {
        enemyRangeXAverage.add(enemyRangeX.getRange());
        enemyRangeYAverage.add(enemyRangeY.getRange());
    }

    @Override
    @NotNull
    public State collect(@NotNull InstantState instant) {
        MovingAverage it;
        Intrinsics.checkParameterIsNotNull(instant, "instant");
        InstantState instantState = instant;
        EnemyState enemy = instantState.component3();
        Iterable $receiver$iv = velocityAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getVelocity());
        }
        $receiver$iv = distanceAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getDistance());
        }
        $receiver$iv = normalizedXAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getNormalizedAbsPositionX());
        }
        $receiver$iv = normalizedYAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getNormalizedAbsPositionY());
        }
        $receiver$iv = normalizedDistanceFromCenterAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getNormalizedDistanceFromCenter());
        }
        $receiver$iv = gunRelatedEnemyBearingAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(instant.getEnemyBearingFromGun());
        }
        $receiver$iv = gunRelatedEnemyHeadingAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(instant.getEnemyHeadingFromGun());
        }
        $receiver$iv = absGunRelatedEnemyBearingAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(Math.abs(instant.getEnemyBearingFromGun()));
        }
        $receiver$iv = absGunRelatedEnemyHeadingAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(Math.abs(instant.getEnemyHeadingFromGun()));
        }
        this.collectEnemyPosition(enemy);
        return new State(instant, new AggregateState(this.extractBooleans(enemy), this.extractFloats(instant)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Boolean> extractBooleans(EnemyState enemy) {
        Collection<Boolean> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        List list = new ArrayList();
        list.add(enemy.getEnergy() == 0.0);
        Iterable iterable = CollectionsKt.listOf(new Double[]{0.4, 0.6, 0.8, 1.0, 1.2});
        List list2 = list;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            Boolean bl = enemy.getNormalizedDistanceFromCenter() < it;
            collection.add(bl);
        }
        collection = (List)destination$iv$iv;
        list2.addAll((Collection)collection);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Double> extractFloats(InstantState instant) {
        void world;
        Double d;
        MovingAverage it;
        Collection<Double> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        InstantState instantState = instant;
        WorldState worldState = instantState.component1();
        EnemyState enemy = instantState.component3();
        List list = new ArrayList();
        list.add(instant.getEnemyBearingFromGun());
        list.add(instant.getEnemyHeadingFromGun());
        list.add(instant.getLinearRotationPrediction1());
        list.add(instant.getLinearRotationPrediction2());
        list.add(enemy.getDistance());
        list.add(enemy.getVelocity());
        list.add(enemy.getNormalizedDistanceFromCenter());
        Iterable iterable = velocityAverages;
        List list2 = list;
        void var6_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            MovingAverage movingAverage = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll((Collection)collection);
        $receiver$iv = distanceAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = normalizedDistanceFromCenterAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = gunRelatedEnemyBearingAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = gunRelatedEnemyHeadingAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = absGunRelatedEnemyBearingAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = absGunRelatedEnemyHeadingAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        list.addAll((Collection)this.extractRanges(world.getWidth() * world.getHeight()));
        return list;
    }

    private final void collectEnemyPosition(EnemyState enemy) {
        enemyRangeX.add(enemy.getAbsoluteX());
        if (enemyRangeXAverage.isEmpty()) {
            enemyRangeXAverage.add(enemyRangeX.getRange());
        }
        enemyRangeY.add(enemy.getAbsoluteY());
        if (enemyRangeYAverage.isEmpty()) {
            enemyRangeYAverage.add(enemyRangeY.getRange());
        }
    }

    private final List<Double> extractRanges(double worldArea) {
        return CollectionsKt.listOf(new Double[]{enemyRangeX.getRange(), enemyRangeY.getRange(), enemyRangeXAverage.getAverage(), enemyRangeYAverage.getAverage(), enemyRangeX.getRange() * enemyRangeY.getRange() / worldArea, enemyRangeXAverage.getAverage() * enemyRangeYAverage.getAverage() / worldArea});
    }

    private StateCollectorImpl() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        MovingAverage movingAverage;
        int it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        StateCollectorImpl stateCollectorImpl;
        INSTANCE = stateCollectorImpl = new StateCollectorImpl();
        Iterable iterable = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        velocityAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        distanceAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        normalizedXAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        normalizedYAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        normalizedDistanceFromCenterAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        gunRelatedEnemyBearingAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        gunRelatedEnemyHeadingAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        absGunRelatedEnemyBearingAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        absGunRelatedEnemyHeadingAverages = CollectionsKt.toList((List)var3_3);
        enemyRangeX = new MinMaxCollector();
        enemyRangeY = new MinMaxCollector();
        enemyRangeXAverage = new MovingAverage(35);
        enemyRangeYAverage = new MovingAverage(35);
    }
}

