/*
 * Decompiled with CFR 0.152.
 */
package drm.common3;

import robocode.Robot;

public class Utils {
    public static double normalRelativeAngle(double deg) {
        while (deg >= 180.0) {
            deg -= 360.0;
        }
        while (deg < -180.0) {
            deg += 360.0;
        }
        return deg;
    }

    public static double normalAbsoluteAngle(double deg) {
        while (deg >= 360.0) {
            deg -= 360.0;
        }
        while (deg < 0.0) {
            deg += 360.0;
        }
        return deg;
    }

    public static double calcAbsoluteBearing(double x, double y, double dx, double dy) {
        double ret = Utils.normalAbsoluteAngle(Math.toDegrees(Math.atan2(dx - x, dy - y)));
        return ret;
    }

    public static double calcRelativeBearing(double heading, double x, double y, double dx, double dy) {
        double ret = Utils.normalRelativeAngle(Math.toDegrees(Math.atan2(dx - x, dy - y)) - heading);
        return ret;
    }

    public static double calcDistance(double x, double y, double dx, double dy) {
        double ret = Math.sqrt((dx - x) * (dx - x) + (dy - y) * (dy - y));
        return ret;
    }

    public static double getBulletGain(double Power) {
        return (double)3 * Power;
    }

    public static double getBulletDamage(double Power) {
        return Power > 1.0 ? (double)4 * Power + (double)2 * (Power - 1.0) : (double)4 * Power;
    }

    public static double getBulletPowerToKill(double Energy) {
        if (Energy <= (double)4) {
            return Energy / (double)4 + 0.1;
        }
        return (Energy - (double)4) / 6.0 + 1.01;
    }

    public static double getBulletVelocity(double Power) {
        return 20.0 - (double)3 * Power;
    }

    public static double getRobotMaxTurning(double Velocity) {
        return 10.0 - 0.75 * Math.abs(Velocity);
    }

    public static double getTurretMaxTurning() {
        return 20.0;
    }

    public static double getRadarMaxTurning() {
        return 45.0;
    }

    public static double getRobotAccVelocity(double curSpeed, boolean Accelerate) {
        if (curSpeed >= 0.0) {
            if (Accelerate) {
                return Math.min(curSpeed + 1.0, 8.0);
            }
            if (curSpeed > 0.0) {
                return Math.max(curSpeed - (double)2, 0.0);
            }
            return -1.0;
        }
        if (Accelerate) {
            return Math.max(curSpeed - 1.0, -8.0);
        }
        return Math.min(curSpeed + (double)2, 0.0);
    }

    public static double getWallHitDamage(double velocity) {
        return Math.abs(velocity) / (double)2;
    }

    public static double getRobotHitDamage() {
        return 0.6;
    }

    public static double calcGunHeat(double power) {
        return 1.0 + power / (double)5;
    }

    public static double getDistanceToKeepVelocity(double velocity) {
        double ret;
        block3: {
            block2: {
                ret = 0.0;
                if (!(velocity > 0.0)) break block2;
                while (velocity > 0.0) {
                    ret += velocity;
                    velocity -= (double)2;
                }
                break block3;
            }
            if (!(velocity < 0.0)) break block3;
            while (velocity < 0.0) {
                ret += velocity;
                velocity += (double)2;
            }
        }
        return ret;
    }

    public static boolean chkOutOfBattleFieldXY(double x, double y, Robot robot) {
        boolean ret = false;
        if (x < 0.0 || x > robot.getBattleFieldWidth() || y < 0.0 || y > robot.getBattleFieldHeight()) {
            ret = true;
        }
        return ret;
    }

    public static boolean chkOutOfBattleField(double heading, double distance, Robot robot) {
        boolean ret = false;
        double x = robot.getX() + distance * Math.sin(Math.toRadians(heading));
        double y = robot.getY() + distance * Math.cos(Math.toRadians(heading));
        if (x < 0.0 + Utils.getRobotR() || x > robot.getBattleFieldWidth() - Utils.getRobotR() || y < 0.0 + Utils.getRobotR() || y > robot.getBattleFieldHeight() - Utils.getRobotR()) {
            ret = true;
        }
        return ret;
    }

    public static boolean chkOutOfBattleField(double xx, double yy, double heading, double distance, Robot robot) {
        boolean ret = false;
        double x = xx + distance * Math.sin(Math.toRadians(heading));
        double y = yy + distance * Math.cos(Math.toRadians(heading));
        if (x < 0.0 + Utils.getRobotR() || x > robot.getBattleFieldWidth() - Utils.getRobotR() || y < 0.0 + Utils.getRobotR() || y > robot.getBattleFieldHeight() - Utils.getRobotR()) {
            ret = true;
        }
        return ret;
    }

    public static double getRobotR() {
        return 20.0;
    }
}

