/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy;

import alk.lap.LoudAndProud;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;

public class VirtualBullet {
    private static String names = "ABCDEFGHIKL";
    protected LoudAndProud proud;
    private DVektor currentPosition;
    protected DVektor emittingPosition;
    private static int currentName = 0;
    private DVektor bulletV;
    private TargetStrategy emittingStrategy;
    public String label;
    private double power;
    private double bulletVelocity;
    protected double angle;
    private boolean valid;

    public VirtualBullet(LoudAndProud proud, TargetStrategy tStrategy) {
        this.proud = proud;
        this.emittingStrategy = tStrategy;
        this.emittingPosition = proud.getPosition();
        this.currentPosition = this.emittingPosition.copy();
        this.label = String.valueOf(tStrategy.describe()) + "(" + names.substring(currentName, currentName + 1) + ")";
        currentName = (currentName + 1) % 10;
        this.power = tStrategy.getFireEnergy();
        this.angle = tStrategy.getFireAngleTo(0, null)[0];
        this.bulletVelocity = 20.0 - 3.0 * this.power;
        this.bulletV = DVektor.fromPolarCoord(this.angle, this.bulletVelocity);
        this.valid = true;
    }

    public void increment() {
        this.draw();
        this.currentPosition.add(this.bulletV);
        if (this.valid) {
            this.valid = this.proud.getTacticLead().isEnemySpotted() ? this.emittingPosition.getDistanceTo(this.currentPosition) <= this.emittingPosition.getDistanceTo(this.proud.getTacticLead().getEnemyPos()) + this.proud.getProudsRadius() : false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void checkForHit(DVektor enemyPos) {
        if (this.valid && this.proud.getTacticLead().bulletHitsBot(this.currentPosition, DVektor.add(this.currentPosition, this.bulletV), enemyPos)) {
            this.proud.getStrategicLead().getAnalystsDB().incrementHit(this.emittingStrategy.describe(), this.emittingPosition.getDistanceTo(enemyPos));
            this.valid = false;
        }
    }

    protected void draw() {
        this.proud.getVc().drawPoint(this.currentPosition, this.label, this.emittingStrategy.getColorCode());
    }
}

