/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.utils;

import alk.lap.LoudAndProud;
import alk.lap.SpottingRobotI;
import alk.lap.utils.DVektor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashSet;

public class VirtualCanvas {
    private HashSet<DrawObject> objects;
    private SpottingRobotI bot;

    public VirtualCanvas(SpottingRobotI bot) {
        this.reset();
        this.bot = bot;
    }

    public void reset() {
        this.objects = new HashSet();
    }

    public void paint(Graphics2D g) {
        try {
            for (DrawObject element : this.objects) {
                element.draw(g);
            }
        }
        catch (Exception e) {
            this.bot.log("ex1:" + e.getMessage());
        }
    }

    public void cleanUp() {
        HashSet<DrawObject> toBeRemoved = null;
        try {
            for (DrawObject element : this.objects) {
                if (!element.ageIsReached()) continue;
                if (toBeRemoved == null) {
                    toBeRemoved = new HashSet<DrawObject>();
                }
                toBeRemoved.add(element);
            }
            if (toBeRemoved != null) {
                this.objects.removeAll(toBeRemoved);
            }
        }
        catch (Exception e) {
            this.bot.log("ex:" + e.getMessage());
        }
    }

    public void drawPoint(DVektor p1, String label) {
        if (this.bot.isTalking()) {
            this.drawPoint(p1, label, 1);
        }
    }

    public void drawPoint(DVektor p1, String label, int maxAge) {
        if (this.bot.isTalking()) {
            this.drawPoint(p1, label, maxAge, Color.green);
        }
    }

    public void drawPoint(DVektor p1, String label, Color color) {
        if (this.bot.isTalking()) {
            this.drawPoint(p1, label, 1, color);
        }
    }

    public void drawPoint(DVektor p1, String label, int maxAge, Color color) {
        if (this.bot.isTalking()) {
            this.objects.add(new NamedPoint(p1, label, maxAge, color));
        }
    }

    public void drawLine(DVektor p1, DVektor p2, String label) {
        if (this.bot.isTalking()) {
            this.drawLine(p1, p2, label, 1);
        }
    }

    public void drawLine(DVektor p1, DVektor p2, String label, int maxAge) {
        if (this.bot.isTalking()) {
            this.drawLine(p1, p2, label, maxAge, Color.green);
        }
    }

    public void drawLine(DVektor p1, DVektor p2, String label, Color color) {
        if (this.bot.isTalking()) {
            this.drawLine(p1, p2, label, 1, color);
        }
    }

    public void drawLine(DVektor p1, DVektor p2, String label, int maxAge, Color color) {
        if (this.bot.isTalking()) {
            this.objects.add(new NamedLine(p1, p2, label, maxAge, color));
        }
    }

    public void drawRect(DVektor p1, DVektor p2, String label, Color color) {
        if (this.bot.isTalking()) {
            this.objects.add(new NamedRect(p1, p2, label, 1, color));
        }
    }

    public void drawDirection(DVektor p1, double angle, String label) {
        if (this.bot.isTalking()) {
            this.drawDirection(p1, angle, label, 1);
        }
    }

    public void drawDirection(DVektor p1, double angle, String label, int maxAge) {
        if (this.bot.isTalking()) {
            this.drawDirection(p1, angle, label, maxAge, Color.red);
        }
    }

    public void drawDirection(DVektor p1, double angle, String label, Color color) {
        if (this.bot.isTalking()) {
            this.drawDirection(p1, angle, label, 1, color);
        }
    }

    public void drawDirection(DVektor p1, double angle, String label, int maxAge, Color color) {
        if (this.bot.isTalking()) {
            this.objects.add(new NamedDirection(p1, angle, label, maxAge, color));
        }
    }

    public void drawCircle(DVektor p1, double radius, String label, int maxAge, Color color) {
        if (this.bot.isTalking()) {
            this.objects.add(new NamedCircle(p1, radius, label, maxAge, color));
        }
    }

    public void drawCircle(DVektor p1, double radius, String label, int maxAge) {
        if (this.bot.isTalking()) {
            this.drawCircle(p1, radius, label, maxAge, Color.lightGray);
        }
    }

    public void drawCircle(DVektor p1, double radius, String label, Color color) {
        if (this.bot.isTalking()) {
            this.drawCircle(p1, radius, label, 1, color);
        }
    }

    public void drawCircle(DVektor p1, double radius, String label) {
        if (this.bot.isTalking()) {
            this.drawCircle(p1, radius, label, 1);
        }
    }

    public static Color dimColor(Color c, double brightness) {
        return new Color((int)((double)c.getRed() * brightness), (int)((double)c.getGreen() * brightness), (int)((double)c.getBlue() * brightness));
    }

    private abstract class DrawObject {
        String label;
        long lastValidTurn;
        Color color;

        public DrawObject(String label, long maxAge, Color color) {
            this.lastValidTurn = VirtualCanvas.this.bot.getTime();
            this.label = label;
            this.color = color;
            this.lastValidTurn += maxAge;
        }

        public abstract void draw(Graphics2D var1);

        public boolean ageIsReached() {
            return VirtualCanvas.this.bot.getTime() >= this.lastValidTurn;
        }
    }

    private class NamedLine
    extends DrawObject {
        DVektor p1;
        DVektor p2;

        public NamedLine(DVektor p1, DVektor p2, String label, int maxAge, Color color) {
            super(label, maxAge, color);
            this.p1 = p1.copy();
            this.p2 = p2.copy();
        }

        public void draw(Graphics2D g) {
            g.setColor(this.color);
            g.drawLine(this.p1.getIntX(), this.p1.getIntY(), this.p2.getIntX(), this.p2.getIntY());
            g.drawString(this.label, this.p1.getIntX() + 6, this.p1.getIntY() - 15);
        }
    }

    private class NamedRect
    extends DrawObject {
        DVektor p1;
        DVektor p2;

        public NamedRect(DVektor p1, DVektor p2, String label, int maxAge, Color color) {
            super(label, maxAge, color);
            this.p1 = p1.copy();
            this.p2 = p2.copy();
        }

        public void draw(Graphics2D g) {
            g.setColor(this.color);
            g.drawLine(this.p1.getIntX(), this.p1.getIntY(), this.p2.getIntX(), this.p1.getIntY());
            g.drawLine(this.p1.getIntX(), this.p1.getIntY(), this.p1.getIntX(), this.p2.getIntY());
            g.drawLine(this.p2.getIntX(), this.p2.getIntY(), this.p2.getIntX(), this.p1.getIntY());
            g.drawLine(this.p2.getIntX(), this.p2.getIntY(), this.p1.getIntX(), this.p2.getIntY());
            g.drawString(this.label, this.p1.getIntX(), this.p1.getIntY() + 5);
        }
    }

    private class NamedDirection
    extends DrawObject {
        DVektor p1;
        double angle;

        public NamedDirection(DVektor p1, double angle, String label, int maxAge, Color color) {
            super(label, maxAge, color);
            this.p1 = p1.copy();
            this.angle = angle;
        }

        public void draw(Graphics2D g) {
            g.setColor(this.color);
            DVektor dir = DVektor.add(this.p1, DVektor.fromPolarCoord(this.angle, 80.0));
            g.drawLine(this.p1.getIntX(), this.p1.getIntY(), dir.getIntX(), dir.getIntY());
            g.drawString(String.valueOf(this.label) + ":" + LoudAndProud.printStaticDouble(this.angle) + "deg", dir.getIntX() + 6, dir.getIntY() - 15);
        }
    }

    private class NamedPoint
    extends DrawObject {
        DVektor p1;

        public NamedPoint(DVektor p1, String label, int maxAge, Color color) {
            super(label, maxAge, color);
            this.p1 = p1;
        }

        public void draw(Graphics2D g) {
            g.setColor(this.color);
            g.fillRect(this.p1.getIntX() - 2, this.p1.getIntY() - 2, 4, 4);
            g.drawString(this.label, this.p1.getIntX() + 6, this.p1.getIntY() - 15);
        }
    }

    private class NamedCircle
    extends DrawObject {
        DVektor p1;
        int radius;
        double directionOfLabel;
        private DVektor labelPos;

        public NamedCircle(DVektor p1, double radius, String label, int maxAge, Color color) {
            super(label, maxAge, color);
            this.p1 = p1;
            this.radius = (int)radius;
            double mostDistX = 0.0;
            double mostDistY = 0.0;
            if (p1.x < VirtualCanvas.this.bot.getBattleFieldWidth() / 2.0) {
                mostDistX = VirtualCanvas.this.bot.getBattleFieldWidth();
            }
            if (p1.y < VirtualCanvas.this.bot.getBattleFieldHeight() / 2.0) {
                mostDistY = VirtualCanvas.this.bot.getBattleFieldHeight();
            }
            DVektor dToLabel = new DVektor(mostDistX - p1.x, mostDistY - p1.y);
            this.labelPos = DVektor.add(p1, DVektor.scaleVector(dToLabel, radius / dToLabel.getLength()));
        }

        public void draw(Graphics2D g) {
            g.setColor(this.color);
            g.drawOval(this.p1.getIntX() - this.radius, this.p1.getIntY() - this.radius, 2 * this.radius, 2 * this.radius);
            g.drawString(this.label, this.labelPos.getIntX() + 6, this.labelPos.getIntY() - 15);
        }
    }
}

