/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import starpkg.EnemyData;
import starpkg.EnemyMoveAnlyData;
import starpkg.EnemyMoveRec;
import starpkg.EnemyType;
import starpkg.HelperTools;
import starpkg.Position;
import starpkg.Rect;
import starpkg.StarViewerZ;

public class EnemyMoveAnalyser {
    StarViewerZ robot = null;
    EnemyData enemy = null;
    EnemyType type = new EnemyType();
    HelperTools tools = null;
    public int enemyMoveType = 0;
    public int lastEnemyMoveType = 0;
    public int lastAyEnemyMoveType = 0;
    private final double MAX_JIGG_DISTANCE = 250.0;
    private final double MAX_JIGG_DIFFERENT = 70.0;
    private final double MIN_JIGG_DISTANCE = 10.0;
    public final int MAX_MOVEDATA = 3;
    public EnemyMoveAnlyData[] eMoveData = new EnemyMoveAnlyData[3];
    public int movePtr = 0;
    private EnemyMoveAnlyData tmpMoveData = new EnemyMoveAnlyData();
    private long saveTime;
    private Rect chkRect = new Rect(new Position(0.0, 0.0), new Position(1.0, 1.0));
    private boolean jiggling = false;
    private boolean atStart = true;
    private boolean startCatch = false;
    private double lastHeading = 0.0;
    private double lastHeadingTurn = 0.0;
    private long lastHeadingTurnTime = 0L;
    private long snakeMoveTime = 0L;
    private boolean snakeMoving = false;
    private boolean forceSaveStopPos = true;
    public final int MAX_HEADING_ARRAY = 3;
    public int headArrayPtr = 0;
    public long sqMoveTime = 0L;
    public long sqMoveTimeOutTime = 0L;
    public double[] headingArray = new double[3];
    public double squareDistance = 0.0;
    public boolean squareMoving = false;
    public boolean startTurning = false;
    public boolean markHeading = false;
    public Position turnPos = new Position();
    public int turnCounter = 0;

    public EnemyMoveAnalyser(StarViewerZ getRobot) {
        this.robot = getRobot;
        this.enemy = this.robot.enemy.enemyMain;
        this.tools = this.robot.tools;
        int i = 0;
        while (i < 3) {
            this.eMoveData[i] = new EnemyMoveAnlyData();
            ++i;
        }
        this.Reset();
    }

    public void Update() {
        this.enemy = this.robot.enemy.enemyMain;
        double headTurn = this.tools.CalHeadingTurnDifferent(this.enemy.heading_deg, this.lastHeading);
        this.snakeMoving = false;
        if (this.lastHeadingTurn > 0.0 && headTurn < 0.0) {
            this.snakeMoving = true;
        } else if (this.lastHeadingTurn < 0.0 && headTurn > 0.0) {
            this.snakeMoving = true;
        }
        if (this.snakeMoving) {
            this.snakeMoveTime = this.robot.getTime();
        } else if (this.robot.getTime() - this.snakeMoveTime <= 10L) {
            this.snakeMoving = true;
        }
        if (!this.startCatch) {
            boolean posInside = this.chkRect.PointInside(this.enemy.pos);
            if (!posInside && !this.forceSaveStopPos) {
                this.chkRect = new Rect(new Position(this.enemy.pos.X - 2.0, this.enemy.pos.Y - 2.0), new Position(this.enemy.pos.X + 2.0, this.enemy.pos.Y + 2.0));
            } else {
                if (this.atStart) {
                    this.tmpMoveData.fromPos = new Position(this.enemy.pos);
                    this.saveTime = this.robot.getTime();
                    this.startCatch = true;
                    this.atStart = false;
                } else {
                    this.tmpMoveData.toPos = new Position(this.enemy.pos);
                    this.tmpMoveData.toPosStartStopTime = this.robot.getTime();
                    this.eMoveData[this.movePtr].Update(this.tmpMoveData);
                    this.tmpMoveData.fromPos = new Position(this.enemy.pos);
                    this.saveTime = this.robot.getTime();
                    this.startCatch = true;
                    ++this.movePtr;
                    if (this.movePtr >= 3) {
                        this.movePtr = 0;
                    }
                }
                this.forceSaveStopPos = false;
            }
        } else if (!this.chkRect.PointInside(this.enemy.pos)) {
            this.tmpMoveData.fromPosStopTime = this.robot.getTime() - this.saveTime;
            this.tmpMoveData.fromPosStartMoveTime = this.robot.getTime();
            this.startCatch = false;
        }
        int curMoveDataPtr = this.movePtr - 1;
        if (curMoveDataPtr < 0) {
            curMoveDataPtr = 2;
        }
        double curDist = this.enemy.pos.Distance(this.tmpMoveData.fromPos);
        if (this.snakeMoving || Math.abs(headTurn) <= 3.0) {
            if (this.lastEnemyMoveType != 1) {
                this.lastEnemyMoveType = this.enemyMoveType;
            }
            this.enemyMoveType = 1;
        } else if (Math.abs(headTurn) > 3.0) {
            if (this.lastEnemyMoveType != 2) {
                this.lastEnemyMoveType = this.enemyMoveType;
            }
            this.enemyMoveType = 2;
        }
        if (curDist <= 250.0 && !(curDist - this.eMoveData[curMoveDataPtr].distance > 70.0)) {
            int preMoveDataPtr = curMoveDataPtr - 1;
            if (preMoveDataPtr < 0) {
                preMoveDataPtr = 2;
            }
            if (Math.abs(this.eMoveData[curMoveDataPtr].distance - this.eMoveData[preMoveDataPtr].distance) <= 70.0 && this.eMoveData[curMoveDataPtr].distance >= 10.0) {
                double diffAngle;
                if (preMoveDataPtr < 0) {
                    preMoveDataPtr = 2;
                }
                if ((diffAngle = this.tools.GetAngleDifferent(this.eMoveData[curMoveDataPtr].heading, this.eMoveData[preMoveDataPtr].heading)) > 130.0) {
                    if (this.lastEnemyMoveType != 4) {
                        this.lastEnemyMoveType = this.enemyMoveType;
                    }
                    this.enemyMoveType = 4;
                } else if (diffAngle > 70.0 && diffAngle < 110.0) {
                    if (this.lastEnemyMoveType != 128) {
                        this.lastEnemyMoveType = this.enemyMoveType;
                    }
                    this.enemyMoveType = 128;
                } else if (diffAngle < 40.0) {
                    if (this.lastEnemyMoveType != 8) {
                        this.lastEnemyMoveType = this.enemyMoveType;
                    }
                    this.enemyMoveType = 8;
                } else {
                    if (this.lastEnemyMoveType != 0) {
                        this.lastEnemyMoveType = this.enemyMoveType;
                    }
                    this.enemyMoveType = 256;
                }
            } else if (this.eMoveData[curMoveDataPtr].distance < 10.0) {
                if (this.lastEnemyMoveType != 0) {
                    this.lastEnemyMoveType = this.enemyMoveType;
                }
                this.enemyMoveType = 256;
            }
        }
        if (this.lastAyEnemyMoveType != this.enemyMoveType) {
            EnemyMoveRec enemyMoveRec = new EnemyMoveRec();
            enemyMoveRec.type = this.enemyMoveType;
            enemyMoveRec.startTime = this.robot.getTime();
            this.enemy.moveRecList.add(enemyMoveRec);
            this.lastAyEnemyMoveType = this.enemyMoveType;
        }
        this.lastHeading = this.enemy.heading_deg;
        if (this.robot.getTime() - this.lastHeadingTurnTime >= 5L) {
            this.lastHeadingTurn = headTurn;
            this.lastHeadingTurnTime = this.robot.getTime();
        }
        if (this.snakeMoving) {
            this.SquareMoveAnalyser();
        }
    }

    public void SquareMoveAnalyser() {
        double headTurn = 0.0;
        if (!this.markHeading) {
            if (this.robot.getTime() - this.sqMoveTime > 10L) {
                this.headingArray[this.headArrayPtr] = this.enemy.heading_deg;
                this.markHeading = true;
                ++this.headArrayPtr;
                if (this.headArrayPtr >= 3) {
                    this.headArrayPtr = 0;
                }
                this.sqMoveTimeOutTime = this.robot.getTime();
            }
        } else {
            headTurn = this.tools.GetAngleDifferent(this.headingArray[this.headArrayPtr], this.enemy.heading_deg);
            if (headTurn > 180.0) {
                headTurn = 360.0 - headTurn;
            }
            if (headTurn > 80.0 && headTurn < 100.0) {
                this.forceSaveStopPos = true;
                this.markHeading = false;
                this.sqMoveTime = this.robot.getTime();
            } else if (this.robot.getTime() - this.sqMoveTimeOutTime > 40L) {
                this.markHeading = false;
            }
        }
    }

    public void SquareMoveAnalyserReset() {
        int i = 0;
        while (i < 3) {
            this.headingArray[i] = -1.0;
            ++i;
        }
        this.squareMoving = false;
        this.startTurning = false;
        this.headArrayPtr = 0;
        this.markHeading = false;
        this.turnCounter = 0;
    }

    public void Reset() {
        this.atStart = true;
        this.startCatch = false;
        this.movePtr = 0;
        this.jiggling = false;
        this.enemyMoveType = 0;
        this.lastEnemyMoveType = 0;
        this.tmpMoveData.Reset();
        int i = 0;
        while (i < 3) {
            this.eMoveData[i].Reset();
            ++i;
        }
        this.SquareMoveAnalyserReset();
        this.forceSaveStopPos = true;
    }
}

