/*
 * Decompiled with CFR 0.152.
 */
package asd.gun;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class VirtualBullet {
    static double PRECISON_OF_TICK = 10.0;
    static double PRECISON_OF_BULLET = 20.0;
    private String name;
    private double bulletStrength;
    private int IDgun;
    private long tickShotted;
    private long tickArrive;
    private boolean colpito;
    private Bullet bulletHit;
    private double shoterX;
    private double shoterY;
    private double spostamentoX;
    private double spostamentoY;
    private long lastUpdate;

    public int update(long tick) {
        this.lastUpdate = tick;
        if ((double)this.tickArrive + PRECISON_OF_TICK < (double)tick) {
            if (this.colpito) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public void update(BulletHitEvent e) {
        if (e.getName().equals(this.name)) {
            double shotX = this.shoterX + this.spostamentoX * (double)(e.getTime() - this.tickShotted);
            double shotY = this.shoterY + this.spostamentoY * (double)(e.getTime() - this.tickShotted);
            double bulletX = e.getBullet().getX();
            double bulletY = e.getBullet().getY();
            if (this.near(bulletX, shotX) && this.near(bulletY, shotY)) {
                this.bulletHit = e.getBullet();
                this.colpito = true;
            }
        }
    }

    public void update(ArrayList events, AdvancedRobot myself) {
        ScannedRobotEvent e = (ScannedRobotEvent)events.get(events.size() - 1);
        if (e.getName().equals(this.name)) {
            double enemyBearing = myself.getHeading() + e.getBearing();
            double enemyX = myself.getX() + e.getDistance() * Math.sin(Math.toRadians(enemyBearing));
            double enemyY = myself.getY() + e.getDistance() * Math.cos(Math.toRadians(enemyBearing));
            double shotX = this.shoterX + this.spostamentoX * (double)(e.getTime() - this.tickShotted);
            double shotY = this.shoterY + this.spostamentoY * (double)(e.getTime() - this.tickShotted);
            if (this.near(enemyX, shotX) && this.near(enemyY, shotY)) {
                this.colpito = true;
            }
        }
    }

    public int getIDgun() {
        return this.IDgun;
    }

    private final boolean near(double a, double b) {
        return a < b + PRECISON_OF_BULLET && a > b - PRECISON_OF_BULLET;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "target: " + this.name + " gun used: " + this.IDgun + " hitted: " + this.colpito;
    }

    public void paint(Graphics2D g) {
        double shotX = this.shoterX + this.spostamentoX * (double)(this.lastUpdate - this.tickShotted);
        double shotY = this.shoterY + this.spostamentoY * (double)(this.lastUpdate - this.tickShotted);
        switch (this.IDgun) {
            case 0: {
                g.setColor(Color.black);
                break;
            }
            case 1: {
                g.setColor(Color.blue);
                break;
            }
            case 2: {
                g.setColor(Color.cyan);
                break;
            }
            case 3: {
                g.setColor(Color.orange);
                break;
            }
            case 4: {
                g.setColor(Color.gray);
                break;
            }
            case 5: {
                g.setColor(Color.green);
                break;
            }
            case 6: {
                g.setColor(Color.lightGray);
                break;
            }
            case 7: {
                g.setColor(Color.magenta);
                break;
            }
            case 8: {
                g.setColor(Color.darkGray);
                break;
            }
            case 9: {
                g.setColor(Color.pink);
                break;
            }
            case 10: {
                g.setColor(Color.yellow);
                break;
            }
            default: {
                g.setColor(Color.WHITE);
            }
        }
        double bulletDimension = this.bulletStrength + (double)3;
        int paintShotX = (int)(shotX - bulletDimension / (double)2);
        int paintShotY = (int)(shotY - bulletDimension / (double)2);
        int paintShotH = (int)bulletDimension;
        int paintShotW = (int)bulletDimension;
        g.fillOval(paintShotX, paintShotY, paintShotH, paintShotW);
        if (this.colpito) {
            g.setColor(Color.RED);
        } else {
            g.setColor(Color.WHITE);
        }
        g.drawOval(paintShotX, paintShotY, paintShotH, paintShotW);
    }

    public VirtualBullet(String name, double distance, double bulletStrength, int IDgun, long tickShotted, double shoterX, double shoterY, double gunBearing, double gunHeading) {
        this.name = name;
        this.bulletStrength = bulletStrength;
        this.IDgun = IDgun;
        this.tickShotted = tickShotted;
        this.tickArrive = (long)((double)tickShotted + distance / Rules.getBulletSpeed((double)bulletStrength));
        this.colpito = false;
        this.shoterX = shoterX;
        this.shoterY = shoterY;
        double shotBearing = gunHeading + gunBearing;
        this.spostamentoX = distance * Math.sin(shotBearing);
        this.spostamentoY = distance * Math.cos(shotBearing);
        this.spostamentoX /= (double)(this.tickArrive - tickShotted);
        this.spostamentoY /= (double)(this.tickArrive - tickShotted);
    }
}

