/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.gun;

public class HitrateEstimator {
    private double a = 0.1;
    private double b = 0.1;
    private int count = 0;

    public void waveEnd(boolean hit, double distance, double wavespeed) {
        double maxEscapeAngle = Math.asin(8.0 / wavespeed);
        double halfWidth = Math.min(maxEscapeAngle, Math.atan(18.0 / distance));
        double uncertainArea = Math.max(0.0, maxEscapeAngle - halfWidth);
        if (hit) {
            this.b += uncertainArea / maxEscapeAngle;
        } else {
            this.a += halfWidth / maxEscapeAngle;
        }
        ++this.count;
    }

    public double getHitrate(double distance, double bulletpower) {
        double maxEscapeAngle = Math.asin(8.0 / (20.0 - 3.0 * bulletpower));
        double halfWidth = Math.min(maxEscapeAngle, Math.atan(18.0 / distance));
        double uncertainArea = Math.max(0.0, maxEscapeAngle - halfWidth);
        return this.getHitrateFromData(uncertainArea, halfWidth);
    }

    private double getHitrateFromData(double uncertainArea, double halfWidth) {
        double uncertaintyMultiplier = this.a / this.b;
        double effectiveEscapeAngle = uncertainArea * uncertaintyMultiplier + halfWidth;
        double hitrate = Math.min(1.0, halfWidth / effectiveEscapeAngle);
        return hitrate;
    }

    public int getWaveCount() {
        return this.count;
    }
}

