/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import robocode.Robot;
import robocode.util.Utils;
import tcf.Bot;
import tcf.HistoryBot;

class Arena {
    public final double WIDTH;
    public final double HEIGHT;
    public final double MIN_X;
    public final double MIN_Y;
    public final double MAX_X;
    public final double MAX_Y;
    public final double CEN_X;
    public final double CEN_Y;

    Arena(double d, double d2, double d3, double d4) {
        this.WIDTH = d;
        this.HEIGHT = d2;
        this.MIN_X = d3 / 2.0;
        this.MIN_Y = d4 / 2.0;
        this.MAX_X = this.WIDTH - d3 / 2.0;
        this.MAX_Y = this.HEIGHT - d4 / 2.0;
        this.CEN_X = this.WIDTH / 2.0;
        this.CEN_Y = this.HEIGHT / 2.0;
    }

    Arena(Robot robot) {
        this(robot.getBattleFieldWidth(), robot.getBattleFieldHeight(), robot.getWidth(), robot.getHeight());
    }

    double clipX(double d) {
        return Math.min(Math.max(this.MIN_X, d), this.MAX_X);
    }

    double clipY(double d) {
        return Math.min(Math.max(this.MIN_Y, d), this.MAX_Y);
    }

    double clipX(double d, int n) {
        return Math.min(Math.max((double)n, d), this.WIDTH - (double)n);
    }

    double clipY(double d, int n) {
        return Math.min(Math.max((double)n, d), this.HEIGHT - (double)n);
    }

    boolean containsRobot(double d, double d2) {
        return this.MIN_X <= d && d <= this.MAX_X && this.MIN_Y <= d2 && d2 <= this.MAX_Y;
    }

    boolean containsPoint(double d, double d2) {
        return 0.0 <= d && d <= this.WIDTH && 0.0 <= d2 && d2 <= this.HEIGHT;
    }

    double linearPrediction(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        int n = 0;
        while (true) {
            double d8 = d + (double)n * d3;
            double d9 = d2 + (double)n * d4;
            if (d8 < this.MIN_X || d8 > this.MAX_X || d9 < this.MIN_Y || d9 > this.MAX_Y) {
                return n;
            }
            double d10 = d5 - d8;
            double d11 = d6 - d9;
            if (d10 * d10 + d11 * d11 < (double)(n * n) * d7 * d7) {
                return n;
            }
            ++n;
        }
    }

    double linearPrediction(Bot bot, Bot bot2, double d, double[] dArray) {
        double d2 = Math.sin(bot.heading()) * bot.speed();
        double d3 = Math.cos(bot.heading()) * bot.speed();
        double d4 = this.linearPrediction(bot.x(), bot.y(), d2, d3, bot2.x(), bot2.y(), d);
        dArray[0] = bot.x() + d4 * d2;
        dArray[1] = bot.y() + d4 * d3;
        return d4;
    }

    double circularPrediction(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double[] dArray) {
        double d9 = Utils.normalRelativeAngle((double)(d3 - d5));
        double d10 = d;
        double d11 = d2;
        int n = 0;
        while (true) {
            if (d10 < this.MIN_X || d10 > this.MAX_X || d11 < this.MIN_Y || d11 > this.MAX_Y) {
                d10 = Math.max(this.MIN_X, Math.min(d10, this.MAX_X));
                d11 = Math.max(this.MIN_Y, Math.min(d11, this.MAX_Y));
                break;
            }
            double d12 = d6 - d10;
            double d13 = d7 - d11;
            if (d12 * d12 + d13 * d13 < (double)(n * n) * d8 * d8) break;
            d10 += d4 * Math.sin(d3);
            d11 += d4 * Math.cos(d3);
            d3 += d9;
            ++n;
        }
        dArray[0] = d10;
        dArray[1] = d11;
        return n;
    }

    double circularPrediction(HistoryBot historyBot, Bot bot, double d, double[] dArray) {
        return this.circularPrediction(historyBot.x(), historyBot.y(), historyBot.heading(), historyBot.speed(), historyBot.past().heading(), bot.x(), bot.y(), d, dArray);
    }

    double cornerDistManhattan(double d, double d2) {
        double d3 = Math.min(d - this.MIN_X, this.MAX_X - d);
        double d4 = Math.min(d2 - this.MIN_Y, this.MAX_Y - d2);
        return d3 + d4;
    }

    double edgeDist(double d, double d2) {
        double d3 = Math.min(Math.min(d, this.WIDTH - d), Math.min(d2, this.HEIGHT - d2));
        return d3;
    }

    double closestEdgeX(double d) {
        return d < this.CEN_X ? this.MIN_X : this.MAX_X;
    }

    double closestEdgeY(double d) {
        return d < this.CEN_Y ? this.MIN_Y : this.MAX_Y;
    }

    double edgeDistAhead(Bot bot) {
        double d = Math.sin(bot.heading()) * Math.signum(bot.speed());
        double d2 = Math.cos(bot.heading()) * Math.signum(bot.speed());
        double d3 = Double.POSITIVE_INFINITY;
        if (d <= 0.0) {
            d3 = Math.min(d3, bot.x() - this.MIN_X);
        }
        if (d >= 0.0) {
            d3 = Math.min(d3, this.MAX_X - bot.x());
        }
        if (d2 <= 0.0) {
            d3 = Math.min(d3, bot.y() - this.MIN_Y);
        }
        if (d2 >= 0.0) {
            d3 = Math.min(d3, this.MAX_Y - bot.y());
        }
        return d3;
    }

    double linearDistAhead(Bot bot) {
        double d = Math.signum(bot.speed());
        if (d == 0.0) {
            d = 1.0;
        }
        double d2 = Math.sin(bot.heading()) * d;
        double d3 = Math.cos(bot.heading()) * d;
        double d4 = Double.POSITIVE_INFINITY;
        if (d2 < 0.0) {
            d4 = Math.min(d4, bot.x() / -d2);
        }
        if (d2 > 0.0) {
            d4 = Math.min(d4, (this.WIDTH - bot.x()) / d2);
        }
        if (d3 < 0.0) {
            d4 = Math.min(d4, bot.y() / -d3);
        }
        if (d3 > 0.0) {
            d4 = Math.min(d4, (this.HEIGHT - bot.y()) / d3);
        }
        return d4;
    }
}

