/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import tcf.OppBot;

class Shot {
    static final int TYPE_HOT = 0;
    static final int TYPE_LINEAR = 1;
    static final int TYPE_CIRCULAR = 2;
    static final int TYPE_GF = 3;
    static final int NUM_TYPES = 4;
    OppBot m_opp;
    int m_type;
    double m_weight;
    long m_time;
    double m_dist;
    double m_speed;
    double m_initialX;
    double m_initialY;
    double m_x;
    double m_y;
    double m_vx;
    double m_vy;

    Shot(OppBot oppBot, int n, double d, long l, double d2, double d3, double d4, double d5, double d6) {
        this.m_opp = oppBot;
        this.m_type = n;
        this.m_weight = d;
        this.m_time = l;
        this.m_initialX = d2;
        this.m_initialY = d3;
        this.m_x = d2;
        this.m_y = d3;
        this.m_dist = 0.0;
        double d7 = Math.atan2(d4 - d2, d5 - d3);
        this.m_speed = d6;
        this.m_vx = d6 * Math.sin(d7);
        this.m_vy = d6 * Math.cos(d7);
    }

    OppBot getOpp() {
        return this.m_opp;
    }

    int getType() {
        return this.m_type;
    }

    double getWeight() {
        return this.m_weight;
    }

    long getTime() {
        return this.m_time;
    }

    double getInitialX() {
        return this.m_initialX;
    }

    double getInitialY() {
        return this.m_initialY;
    }

    double getX() {
        return this.m_x;
    }

    double getY() {
        return this.m_y;
    }

    double getDist() {
        return this.m_dist;
    }

    void tick() {
        this.m_x += this.m_vx;
        this.m_y += this.m_vy;
        this.m_dist += this.m_speed;
    }

    double futureX(int n) {
        return this.m_x + (double)n * this.m_vx;
    }

    double futureY(int n) {
        return this.m_y + (double)n * this.m_vy;
    }
}

