/*
 * Decompiled with CFR 0.152.
 */
package jdw.util;

import jdw.util.Painter;

public class AnglePoints {
    private double a;
    private double b;
    private double[][] bins;
    private int num_bins;
    public double max_x;
    public double max_prob;
    public double max_profit;

    public AnglePoints(double min, double max, int accuracy) {
        this.a = (double)accuracy / (max - min);
        this.b = (double)accuracy * 8.0 - min * this.a;
        this.bins = new double[accuracy][2];
        this.num_bins = accuracy;
    }

    public void add(double x1, double x2, double prob, double profit) {
        int ix1 = (int)(x1 * this.a + this.b);
        int ix2 = (int)(x2 * this.a + this.b);
        while (ix1 <= ix2) {
            int i = ix1 % this.num_bins;
            double prob2 = prob - this.bins[i][0] * prob;
            double[] dArray = this.bins[i];
            dArray[0] = dArray[0] + prob2;
            double[] dArray2 = this.bins[i];
            dArray2[1] = dArray2[1] + prob2 * profit;
            ++ix1;
        }
    }

    public void calc_max_profit(double x1, double x2) {
        this.max_x = 0.0;
        this.max_prob = 0.0;
        this.max_profit = 0.0;
        boolean last_max = false;
        int ix1 = (int)(x1 * this.a + this.b) % this.num_bins;
        int ix2 = ((int)(x2 * this.a + this.b) - 1) % this.num_bins;
        while (ix1 <= ix2) {
            double profit = this.bins[ix1][1];
            if (profit > this.max_profit) {
                this.max_x = ix1;
                this.max_prob = this.bins[ix1][0];
                this.max_profit = profit + 1.0E-9;
                last_max = true;
            } else if (last_max && profit < this.max_profit - 2.0E-9) {
                this.max_x = (this.max_x + (double)ix1) * 0.5;
                last_max = false;
            }
            ++ix1;
        }
        if (last_max) {
            this.max_x = (this.max_x + (double)ix1) * 0.5;
        }
        this.max_x = (this.max_x - this.b + (double)this.num_bins * 8.0) / this.a;
    }

    public double profit_at(double x) {
        x = x * this.a + this.b;
        int i = (int)x;
        return this.bins[i % this.num_bins][1] * (1.0 - (x -= (double)i)) + this.bins[(i + 1) % this.num_bins][1] * x;
    }

    public void paint(Painter painter, double x, double y, double rot, double ang_scale) {
        int i = 0;
        while (i < this.num_bins) {
            painter.paint_polar_line(x, y, rot + ((double)i - this.b + (double)this.num_bins * 8.0) / this.a * ang_scale, this.bins[i][1] * 10.0);
            ++i;
        }
    }
}

