/*
 * Decompiled with CFR 0.152.
 */
package EH;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Pegasus
extends AdvancedRobot {
    int movementDirection = 1;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double enemyHeading;
        double bulletPower = this.getEnergy() / 30.0;
        double myX = this.getX();
        double myY = this.getY();
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyX = this.getX() + e.getDistance() * Math.sin(absoluteBearing);
        double enemyY = this.getY() + e.getDistance() * Math.cos(absoluteBearing);
        double oldEnemyHeading = enemyHeading = e.getHeadingRadians();
        double enemyHeadingChange = enemyHeading - oldEnemyHeading;
        double enemyVelocity = e.getVelocity();
        double deltaTime = 0.0;
        double battleFieldHeight = this.getBattleFieldHeight();
        double battleFieldWidth = this.getBattleFieldWidth();
        double predictedX = enemyX;
        double predictedY = enemyY;
        while ((deltaTime += 1.0) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getX(), predictedY - this.getY()));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
        this.setFire(bulletPower);
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(e.getHeadingRadians() - this.getHeadingRadians())));
        this.setAhead(e.getVelocity() * 10.0);
        this.setMaxVelocity(Math.abs(e.getVelocity()));
        this.execute();
    }

    public void onBulletHit() {
    }

    public void onBulletMissed() {
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }
}

