/*
 * Decompiled with CFR 0.152.
 */
package vStar;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Map;
import vStar.PointCommon;
import vStar.PointOfAttraction;
import vStar.PointRelativelyLocated;
import vStar.RAFzilla;
import vStar.SensorCommon;
import vStar.TankEnemy;

class PointSuggest2Move
extends PointRelativelyLocated {
    private SensorCommon block_sensor;
    private double reason;
    private boolean choosen = false;

    public double get_reason() {
        return this.reason;
    }

    public void set_choosen(boolean choosen) {
        this.choosen = choosen;
    }

    public PointSuggest2Move(RAFzilla tank, double moveFwd, double turnRght, SensorCommon stopSensor) {
        super(tank, moveFwd, turnRght);
        this.block_sensor = stopSensor;
    }

    public void draw_point(Graphics2D graf) {
        if (this.choosen) {
            graf.setColor(Color.green);
        } else if (this.reason < -100000.0) {
            graf.setColor(Color.red);
        } else {
            graf.setColor(Color.yellow);
        }
        graf.fillOval((int)this.get_x() - 5, (int)this.get_y() - 5, 10, 10);
        this.block_sensor.draw(graf);
    }

    public void refresh_reason() {
        boolean pvp_really_choosen;
        double cornerPower;
        this.choosen = false;
        this.refresh_location();
        this.reason = this.is_in_battle_field(this.zilla_tank, this.zilla_tank.getHeight() < this.zilla_tank.getWidth() ? this.zilla_tank.getWidth() : this.zilla_tank.getHeight()) ? 0.0 : -1.0E7;
        if (this.zilla_tank.getVelocity() != 0.0 && this.get_distance() > 0.0 == this.zilla_tank.getVelocity() > 0.0) {
            this.reason += 130.0;
        }
        if (this.is_in_square(new PointCommon(0.0, 0.0), new PointCommon(cornerPower = 300.0, cornerPower)) && !this.is_in_circle(new PointCommon(cornerPower, cornerPower), cornerPower) || this.is_in_square(new PointCommon(0.0, this.zilla_tank.getBattleFieldHeight() - cornerPower), new PointCommon(cornerPower, this.zilla_tank.getBattleFieldHeight())) && !this.is_in_circle(new PointCommon(cornerPower, this.zilla_tank.getBattleFieldHeight() - cornerPower), cornerPower) || this.is_in_square(new PointCommon(this.zilla_tank.getBattleFieldWidth() - cornerPower, 0.0), new PointCommon(this.zilla_tank.getBattleFieldWidth(), cornerPower)) && !this.is_in_circle(new PointCommon(this.zilla_tank.getBattleFieldWidth() - cornerPower, cornerPower), cornerPower) || this.is_in_square(new PointCommon(this.zilla_tank.getBattleFieldWidth() - cornerPower, this.zilla_tank.getBattleFieldHeight() - cornerPower), new PointCommon(this.zilla_tank.getBattleFieldWidth(), this.zilla_tank.getBattleFieldHeight())) && !this.is_in_circle(new PointCommon(this.zilla_tank.getBattleFieldWidth() - cornerPower, this.zilla_tank.getBattleFieldHeight() - cornerPower), cornerPower)) {
            this.reason -= 1000000.0;
        }
        for (Map.Entry<String, TankEnemy> enemy : this.zilla_tank.enemy_list.entrySet()) {
            if (!this.block_sensor.is_in_sensor(enemy.getValue()).booleanValue()) continue;
            this.reason -= 1000000.0;
        }
        for (PointOfAttraction attr_point : this.zilla_tank.attraction_points) {
            this.reason -= attr_point.calculate_penalty(this, this.zilla_tank.enemy_list.size());
        }
        int choosen_radiuss = 10000;
        TankEnemy opponent = null;
        if (this.zilla_tank.getOthers() == 1 && 15.0 <= this.zilla_tank.getEnergy() && this.zilla_tank.enemy_list.size() == 1) {
            opponent = (TankEnemy)this.zilla_tank.enemy_list.values().toArray()[0];
            String distance = opponent.stat_per_distance.get_most_effective_distance();
            if (distance == "pvp") {
                pvp_really_choosen = true;
                choosen_radiuss = this.zilla_tank.PVP_RADIUS;
            } else if (distance == "middle") {
                pvp_really_choosen = true;
                choosen_radiuss = this.zilla_tank.MIDDLE_RADIUS;
            } else {
                pvp_really_choosen = false;
            }
        } else {
            pvp_really_choosen = false;
        }
        if (pvp_really_choosen) {
            this.reason -= Math.abs((double)choosen_radiuss - this.get_distance_to(opponent));
        } else {
            double farFromOthersPoints = 0.0;
            double tempDistance = 0.0;
            for (Map.Entry<String, TankEnemy> enemy : this.zilla_tank.enemy_list.entrySet()) {
                tempDistance = this.get_distance_to(enemy.getValue());
                if (tempDistance < 100.0) {
                    this.reason -= 5.0 * (100.0 - tempDistance);
                    continue;
                }
                farFromOthersPoints += tempDistance;
            }
            this.reason += farFromOthersPoints / (double)this.zilla_tank.enemy_list.size();
        }
    }
}

