/*
 * Decompiled with CFR 0.152.
 */
package lrem;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import lrem.FadingGravityCentre;
import lrem.GravityCentre;
import lrem.Other;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;

public class Spectre
extends TeamRobot {
    static final double PI = Math.PI;
    static final double MoveLength = 1000.0;
    static final double OthersGravStrenght = 1000.0;
    static final double OthersGravPower = 2.0;
    static final double DodgeGravStrenght = 100.0;
    static final double DodgeGravPower = 2.0;
    static final int GunIterations = 10;
    static final int SpecCount = 3;
    static final double MoveTime = 20.0;
    static final int Destinations = 5;
    static final double WallMargin = 45.0;
    static Point2D.Double Position = new Point2D.Double(0.0, 0.0);
    static double Heading;
    static double GunHeading;
    static double RadarHeading;
    static double Time;
    static double BattleFieldWidth;
    static double BattleFieldHeight;
    static double Energy;
    static int OthersCount;
    static List DodgePoints;
    static Point2D.Double Destination;
    static Point2D.Double LastPosition;
    static Point2D.Double BattleFieldCentre;
    static HashMap OthersMap;
    static Vector GravPoints;
    static Vector SpecPoints;
    static double SpecTime;
    static Other Target;
    static double FirePower;
    static int RadarDirection;
    static double HoverTime;
    static double LastMove;

    public void run() {
        this.ResetVariables();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.addCustomEvents();
        this.setTurnRadarRightRadians(Math.PI * 2);
        this.setColors(Color.black, Color.gray, Color.black);
        while (true) {
            this.getVariables();
            this.ChooseTarget();
            if (Spectre.Target.Distance < 10000.0) {
                this.DoGun();
            }
            this.AntiGravMove();
            this.GoTo(Destination);
            this.execute();
        }
    }

    public void onCustomEvent(CustomEvent customEvent) {
        this.getVariables();
        if (customEvent.getCondition() instanceof RadarTurnCompleteCondition) {
            this.RadarSweep();
        }
        if (customEvent.getCondition().getName().equals("GunLocked") && FirePower < Energy && Target.IsUpdated(Time)) {
            this.setFire(FirePower);
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        Other other;
        this.getVariables();
        String string = scannedRobotEvent.getName();
        double d = scannedRobotEvent.getBearingRadians();
        if (OthersMap.containsKey(string)) {
            other = (Other)OthersMap.get(scannedRobotEvent.getName());
        } else {
            other = new Other();
            other.BattleFieldWidth = BattleFieldWidth;
            other.BattleFieldHeight = BattleFieldHeight;
            other.Position = new Point2D.Double(0.0, 0.0);
            other.Direction = 1;
            other.ResetWaves();
            OthersMap.put(string, other);
            this.out.println("Mapped a new bot: " + string);
        }
        double d2 = other.Energy;
        other.AbsBearing = Heading + d;
        other.HeadingChange = Spectre.NormaliseBearing(scannedRobotEvent.getHeadingRadians() - other.Heading) / (Time - other.ScanTime);
        other.LastVelocity = other.Velocity;
        Other.Name = string;
        other.Bearing = d;
        other.Distance = scannedRobotEvent.getDistance();
        other.Energy = scannedRobotEvent.getEnergy();
        other.Heading = scannedRobotEvent.getHeadingRadians();
        other.Velocity = scannedRobotEvent.getVelocity();
        other.Position.x = Spectre.Position.x + Math.sin(other.AbsBearing) * other.Distance;
        other.Position.y = Spectre.Position.y + Math.cos(other.AbsBearing) * other.Distance;
        if (other.Velocity != 0.0) {
            other.Direction = Math.sin(other.Heading - other.AbsBearing) * other.Velocity < 0.0 ? -1 : 1;
        }
        other.ScanTime = Time;
        if (other.LastVelocity != other.Velocity) {
            other.AccelerationTime = Time;
        }
        other.IsAlive = true;
        other.HasFired = false;
        if (0.1 <= d2 - other.Energy && d2 - other.Energy <= (double)3) {
            other.HasFired = true;
            other.FirePower = other.Energy - d2;
            DodgePoints.add(new FadingGravityCentre(Position, 100.0, 2, Time + other.Distance / (20.0 - (double)3 * other.FirePower)));
        }
        other.UpdateWaves();
        if ((double)3 < Energy) {
            other.FireWave(Position, OthersCount, this.ChoosePower(other.DistanceIndex()));
        }
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        String string = robotDeathEvent.getName();
        if (OthersMap.containsKey(string)) {
            Other other = (Other)OthersMap.get(robotDeathEvent.getName());
            other.Distance = 10000.0;
            other.IsAlive = false;
        } else {
            Other other = new Other();
            other.BattleFieldWidth = BattleFieldWidth;
            other.BattleFieldHeight = BattleFieldHeight;
            other.Position = new Point2D.Double(0.0, 0.0);
            other.IsAlive = false;
            other.Distance = 10000.0;
            other.Direction = 1;
            other.ResetWaves();
            OthersMap.put(string, other);
        }
    }

    public void onSkippedTurn() {
        this.out.println("Skipped a turn!");
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        this.out.println("Hit a wall!");
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
    }

    void CreateGravPoints() {
        Iterator iterator = OthersMap.values().iterator();
        GravPoints.clear();
        while (iterator.hasNext()) {
            Other other = (Other)iterator.next();
            if (!other.IsAlive) continue;
            GravPoints.add(new GravityCentre(other.Position, 1000.0, 2));
        }
        GravPoints.add(new GravityCentre(BattleFieldCentre, 1000.0 * (double)Other.CountIndex(OthersCount) / (double)2, 3));
        int n = 0;
        while (n < DodgePoints.size()) {
            FadingGravityCentre fadingGravityCentre = (FadingGravityCentre)DodgePoints.get(n);
            if (fadingGravityCentre.FadeTime <= Time) {
                DodgePoints.remove(fadingGravityCentre);
                --n;
            }
            ++n;
        }
        this.out.println(DodgePoints.size());
        GravPoints.addAll(DodgePoints);
    }

    void ChooseTarget() {
        Iterator iterator = OthersMap.values().iterator();
        while (iterator.hasNext()) {
            Other other = (Other)iterator.next();
            if (!other.IsAlive || this.isTeammate(Other.Name) || !(other.Distance < Spectre.Target.Distance)) continue;
            Target = other;
        }
        FirePower = Math.min(600.0 / Spectre.Target.Distance, Spectre.Target.Energy);
    }

    double ChoosePower(double d) {
        return ((double)3 - 1.25 * (d / (double)5)) * 0.75;
    }

    void AntiGravMove() {
        if (LastMove + 20.0 / (double)(Other.CountIndex(OthersCount) + 1) <= Time) {
            this.CreateGravPoints();
            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
            Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
            LastMove = Time;
            double d = Double.POSITIVE_INFINITY;
            int n = 0;
            while (n < 5 * (Other.CountIndex(OthersCount) + 1)) {
                do {
                    double d2 = Math.random() * Math.PI * (double)2;
                    double_2.x = Spectre.Position.x + 160.0 * Math.sin(d2);
                    double_2.y = Spectre.Position.y + 160.0 * Math.cos(d2);
                } while (!Spectre.Field(45.0).contains(double_2));
                double d3 = this.SumGravityForces(double_2);
                if (d3 < d) {
                    d = d3;
                    double_.x = double_2.x;
                    double_.y = double_2.y;
                }
                ++n;
            }
            Destination = double_;
        }
    }

    Point2D.Double ComputeGravity(Point2D.Double double_) {
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        int n = 0;
        while (n < GravPoints.size()) {
            GravityCentre gravityCentre = (GravityCentre)GravPoints.elementAt(n);
            double d = gravityCentre.Strenght / Math.pow(Spectre.GetRange(double_, gravityCentre.Position), gravityCentre.Power);
            double d2 = Spectre.NormaliseBearing(1.5707963267948966 - Math.atan2(double_.y - gravityCentre.Position.y, double_.x - gravityCentre.Position.x));
            double_2.x += Math.sin(d2) * d;
            double_2.y += Math.cos(d2) * d;
            ++n;
        }
        return double_2;
    }

    double SumGravityForces(Point2D.Double double_) {
        double d = 0.0;
        int n = 0;
        while (n < GravPoints.size()) {
            GravityCentre gravityCentre = (GravityCentre)GravPoints.elementAt(n);
            d += gravityCentre.Strenght / Math.pow(Spectre.GetRange(double_, gravityCentre.Position), gravityCentre.Power);
            ++n;
        }
        return d;
    }

    void RadarSweep() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Math.PI * (double)RadarDirection;
        int n = 0;
        Iterator iterator = OthersMap.values().iterator();
        while (iterator.hasNext()) {
            Other other = (Other)iterator.next();
            if (!other.IsAlive || !other.IsUpdated(Time)) continue;
            double d4 = Spectre.NormaliseBearing(Heading + other.Bearing - RadarHeading);
            if (d < Math.abs(d4)) {
                d = Math.abs(d4);
                d2 = d4;
            }
            ++n;
        }
        if (n == OthersCount) {
            d3 = d2 + (double)this.sign(d2) * Math.PI / 16.0;
        }
        this.setTurnRadarRightRadians(d3);
        RadarDirection = this.sign(d3);
    }

    void DoGun() {
        FirePower = this.ChoosePower(Target.DistanceIndex());
        double cfr_ignored_0 = Spectre.Target.MaxVelocity;
        double d = (double)Spectre.Target.Direction * Target.GuessFactor(Position, OthersCount, FirePower) * Math.asin(8.0 / (20.0 - FirePower * (double)3));
        this.setTurnGunRightRadians(Spectre.NormaliseBearing(Spectre.Target.AbsBearing - GunHeading + d));
        double cfr_ignored_1 = Spectre.Target.MaxVelocity;
        this.out.println("" + Spectre.Target.Direction + ' ' + Target.GuessFactor(Position, OthersCount, FirePower) + ' ' + Math.asin(8.0 / (20.0 - FirePower * (double)3)));
        this.out.println("" + Spectre.Target.AbsBearing + ' ' + GunHeading + ' ' + d);
    }

    void GoTo(Point2D.Double double_) {
        double d = Spectre.NormaliseBearing(Heading - Spectre.AbsBearing(Position, double_));
        if (1.5707963267948966 < d) {
            d -= Math.PI;
            this.setBack(100.0);
        } else if (d < -1.5707963267948966) {
            d += Math.PI;
            this.setBack(100.0);
        } else {
            this.setAhead(100.0);
        }
        this.setTurnLeftRadians(d);
    }

    void addCustomEvents() {
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        this.addCustomEvent(new Condition(this, "GunLocked"){
            final /* synthetic */ Spectre this$0;

            public final boolean test() {
                boolean bl = false;
                if (this.this$0.getGunTurnRemainingRadians() == 0.0) {
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = spectre;
            }
        });
    }

    void getVariables() {
        Spectre.Position.x = this.getX();
        Spectre.Position.y = this.getY();
        Time = this.getTime();
        Heading = this.getHeadingRadians();
        GunHeading = this.getGunHeadingRadians();
        RadarHeading = this.getRadarHeadingRadians();
        OthersCount = this.getOthers();
        Energy = this.getEnergy();
    }

    void ResetVariables() {
        BattleFieldWidth = this.getBattleFieldWidth();
        BattleFieldHeight = this.getBattleFieldHeight();
        Spectre.BattleFieldCentre.x = BattleFieldWidth / (double)2;
        Spectre.BattleFieldCentre.y = BattleFieldHeight / (double)2;
        LastMove = Double.NEGATIVE_INFINITY;
        Target = new Other();
        Spectre.Target.Distance = 10000.0;
        SpecTime = Double.NEGATIVE_INFINITY;
        Iterator iterator = OthersMap.values().iterator();
        while (iterator.hasNext()) {
            Other other = (Other)iterator.next();
            other.ResetWaves();
        }
        DodgePoints = new ArrayList();
    }

    public static double NormaliseBearing(double d) {
        if (d > Math.PI) {
            d -= Math.PI * 2;
        }
        if (d < -Math.PI) {
            d += Math.PI * 2;
        }
        return d;
    }

    public static double AbsBearing(Point2D.Double double_, Point2D.Double double_2) {
        double d = double_2.x - double_.x;
        double d2 = double_2.y - double_.y;
        double d3 = Spectre.GetRange(double_, double_2);
        if (d > 0.0 && d2 > 0.0) {
            return Math.asin(d / d3);
        }
        if (d > 0.0 && d2 < 0.0) {
            return Math.PI - Math.asin(d / d3);
        }
        if (d < 0.0 && d2 < 0.0) {
            return Math.PI + Math.asin(-d / d3);
        }
        if (d < 0.0 && d2 > 0.0) {
            return Math.PI * 2 - Math.asin(-d / d3);
        }
        return 0.0;
    }

    public static double GetRange(Point2D.Double double_, Point2D.Double double_2) {
        double d = double_2.x - double_.x;
        double d2 = double_2.y - double_.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public static RoundRectangle2D.Double Field(double d) {
        return new RoundRectangle2D.Double(d, d, BattleFieldWidth - d * (double)2, BattleFieldHeight - d * (double)2, 75.0, 75.0);
    }

    int sign(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public void print(String string) {
        this.out.println(string);
    }

    static {
        Destination = new Point2D.Double(0.0, 0.0);
        LastPosition = new Point2D.Double(0.0, 0.0);
        BattleFieldCentre = new Point2D.Double(0.0, 0.0);
        OthersMap = new HashMap();
        GravPoints = new Vector();
        SpecPoints = new Vector();
        RadarDirection = 1;
        HoverTime = 0.0;
    }
}

