/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.guns.VCS;

import de._4geeks.robots.guns.DC.EnemyFeature;
import de._4geeks.robots.guns.VCS.StatsBuffer;
import de._4geeks.robots.guns.VCS.StatsBufferSet;
import de._4geeks.robots.guns.manager.Wave;
import de._4geeks.robots.utils.GuessFactorWindow;
import java.util.ArrayList;
import robocode.AdvancedRobot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResearchGun
extends StatsBufferSet {
    private int bins;
    private String name;
    private boolean negative;
    private int history;

    public ResearchGun(AdvancedRobot robot, int bins, int history, boolean negative) {
        this.bins = bins;
        this.history = history;
        this.negative = negative;
    }

    public ResearchGun(AdvancedRobot robot, int bins, int history, EnemyFeature feat) {
        this(robot, bins, history, feat, false, "");
    }

    public ResearchGun(AdvancedRobot robot, int bins, int history, EnemyFeature feat, boolean negative) {
        this(robot, bins, history, feat, false, "");
    }

    public ResearchGun(AdvancedRobot robot, int bins, int history, EnemyFeature feat, boolean negative, String nameAdd) {
        this(robot, bins, history, feat, false, nameAdd, 0.125);
    }

    public ResearchGun(AdvancedRobot robot, int bins, int history, EnemyFeature feat, boolean negative, String nameAdd, double nonFiringInfluence) {
        this.bins = bins;
        this.name = String.valueOf(nameAdd) + feat.getFeatureName() + "Gun";
        this.history = history;
        this.negative = negative;
        StatsBuffer buffer = new StatsBuffer(bins, history, 1.0);
        buffer.addFeature(feat);
        buffer.initStats(nonFiringInfluence);
        this.buffers.add(buffer);
    }

    public ResearchGun(AdvancedRobot robot, int bins, int history, ArrayList<EnemyFeature> feats) {
        this(robot, bins, history, feats, false, "");
    }

    public ResearchGun(AdvancedRobot robot, int bins, int history, ArrayList<EnemyFeature> feats, boolean negative, String nameAdd) {
        this(robot, bins, history, feats, false, nameAdd, 0.125);
    }

    public ResearchGun(AdvancedRobot robot, int bins, int history, ArrayList<EnemyFeature> feats, boolean negative, String nameAdd, double nonFiringInfluence) {
        this.bins = bins;
        this.history = history;
        this.negative = negative;
        this.name = nameAdd;
        StatsBuffer buffer = new StatsBuffer(bins, history, 1.0);
        for (EnemyFeature feat : feats) {
            buffer.addFeature(feat);
            this.name = String.valueOf(this.name) + feat.getFeatureName();
        }
        buffer.initStats(nonFiringInfluence);
        this.buffers.add(buffer);
        this.name = String.valueOf(this.name) + "Gun";
    }

    @Override
    public double doAim(Wave wave) {
        double[] bins = new double[this.bins];
        for (StatsBuffer buffer : this.buffers) {
            buffer.getBins(wave, bins);
        }
        double b = this.getBestBin(wave, bins);
        return (b - (double)(this.bins / 2)) / (double)(this.bins / 2);
    }

    @Override
    public void registerWave(Wave wave, GuessFactorWindow window) {
        for (StatsBuffer buffer : this.buffers) {
            if (this.negative) {
                buffer.registerWaveNegativ(wave, window);
                continue;
            }
            buffer.registerWave(wave, window);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setNegative(boolean negative) {
        this.negative = negative;
    }

    public int getHistory() {
        return this.history;
    }

    public int getBins() {
        return this.bins;
    }

    public ArrayList<StatsBuffer> getBuffers() {
        return this.buffers;
    }

    public double[] getBins(Wave wave) {
        double[] bins = new double[this.bins];
        for (StatsBuffer buffer : this.buffers) {
            buffer.getBins(wave, bins);
        }
        return bins;
    }

    public void setName(String name) {
        this.name = name;
    }
}

