/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.utils;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class SUtils {
    public static double NormaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public static double NormaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public static double getrange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public static double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = SUtils.getrange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    public static double sign(double val) {
        if (val >= 0.0) {
            return 1.0;
        }
        return -1.0;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public static double limit(double val, double min, double max) {
        return Math.max(Math.min(val, max), min);
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double sqr(double val) {
        return val * val;
    }

    public static int indexSlice(double[] slices, double val) {
        int i = 0;
        while (i < slices.length) {
            if (val < slices[i]) {
                return i;
            }
            ++i;
        }
        return slices.length;
    }

    public static int indexGuessFactor(int bins, double val) {
        return (int)SUtils.limit(Math.round(val * (double)((bins - 1) / 2)) + (long)((bins - 1) / 2), 0.0, bins - 1);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public static double getEntropy(long[] stats) {
        long total = 0L;
        int i = 0;
        while (i < stats.length) {
            total += stats[i];
            ++i;
        }
        return SUtils.getEntropy(stats, total);
    }

    public static double getEntropy(long[] stats, long total) {
        double entropy = 0.0;
        int i = 0;
        while (i < stats.length) {
            if (stats[i] != 0L) {
                double p = (double)stats[i] / (double)total;
                entropy -= p * Math.log(p);
            }
            ++i;
        }
        return entropy;
    }

    public static double getEntropy(long[][] stats) {
        long[] totals = new long[stats.length];
        long total = 0L;
        double entropy = 0.0;
        int i = 0;
        while (i < stats.length) {
            int j = 0;
            while (j < stats[i].length) {
                int n = i;
                totals[n] = totals[n] + stats[i][j];
                ++j;
            }
            total += totals[i];
            ++i;
        }
        i = 0;
        while (i < stats.length) {
            double partial = SUtils.getEntropy(stats[i], totals[i]);
            entropy += (double)totals[i] * partial / (double)total;
            ++i;
        }
        return entropy;
    }

    public static double informationGain(long[] stats, long total) {
        double entropy = 0.0;
        double binProb = 1.0 / (double)stats.length;
        double evenEntropy = 0.0;
        int i = 0;
        while (i < stats.length) {
            if (stats[i] != 0L) {
                double p = (double)stats[i] / (double)total;
                entropy += p * Math.log(p);
                evenEntropy += p * Math.log(binProb);
            }
            ++i;
        }
        return entropy - evenEntropy;
    }

    public static double informationGain(long[][] stats) {
        long[] totals = new long[stats.length];
        long total = 0L;
        int i = 0;
        while (i < stats.length) {
            int j = 0;
            while (j < stats[i].length) {
                int n = i;
                totals[n] = totals[n] + stats[i][j];
                ++j;
            }
            total += totals[i];
            ++i;
        }
        double entropy = 0.0;
        int i2 = 0;
        while (i2 < stats.length) {
            double partial = SUtils.informationGain(stats[i2], totals[i2]);
            entropy += (double)totals[i2] * partial / (double)total;
            ++i2;
        }
        return entropy;
    }
}

