/*
 * Decompiled with CFR 0.152.
 */
package jaybot.intel;

import jaybot.intel.RunningStatsTracker;

public class RunningStatsBase
implements RunningStatsTracker {
    protected int runningCollisions = 0;
    protected double runningDamageToMe = 0.0;
    protected int runningShotsHittingMe = 0;
    protected double runningDamageToOthers = 0.0;
    protected int runningShotsHitOthers = 0;
    protected int runningShotsMissedOthers = 0;
    protected int runningShotsFired = 0;

    public void resetRunningStats(boolean collisions, boolean damageTaken, boolean shotStats) {
        if (collisions) {
            this.runningCollisions = 0;
        }
        if (damageTaken) {
            this.runningDamageToMe = 0.0;
            this.runningShotsHittingMe = 0;
        }
        if (shotStats) {
            this.runningDamageToOthers = 0.0;
            this.runningShotsHitOthers = 0;
            this.runningShotsMissedOthers = 0;
            this.runningShotsFired = 0;
        }
    }

    public void resetRunningStats() {
        this.resetRunningStats(true, true, true);
    }

    public int getRunningCollisionCount() {
        return this.runningCollisions;
    }

    public double getRunningDamageToMe() {
        return this.runningDamageToMe;
    }

    public double getRunningDamageToOthers() {
        return this.runningDamageToOthers;
    }

    public int getRunningShotsFired() {
        return this.runningShotsFired;
    }

    public int getRunningShotsHit() {
        return this.runningShotsHitOthers;
    }

    public int getRunningShotsMissed() {
        return this.runningShotsMissedOthers;
    }

    public double getRunningShotAccuracy() {
        double totalShots = this.runningShotsHitOthers + this.runningShotsMissedOthers;
        if (totalShots == 0.0) {
            return 0.0;
        }
        return (double)this.runningShotsHitOthers / totalShots * 100.0;
    }

    public int getRunningShotsHitMe() {
        return this.runningShotsHittingMe;
    }

    public int incRunningShotsFired() {
        return ++this.runningShotsFired;
    }

    public int incRunningShotsHit() {
        return ++this.runningShotsHitOthers;
    }

    public int incRunningShotsMissed() {
        return ++this.runningShotsMissedOthers;
    }

    public int incRunningCollissions() {
        return ++this.runningCollisions;
    }

    public double incRunningDamageToMe(double howMuch) {
        this.runningDamageToMe += howMuch;
        return this.runningDamageToMe;
    }

    public double incRunningDamageToOthers(double howMuch) {
        this.runningDamageToOthers += howMuch;
        return this.runningDamageToOthers;
    }
}

