/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.debug.Debug;
import pedersen.physics.StaticHeading;
import pedersen.physics.StaticHeadingImpl;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVelocity;
import pedersen.physics.StaticVelocityImpl;

public class StaticVectorImpl
implements StaticVector {
    private StaticHeading heading;
    private StaticVelocity velocity;

    public StaticVectorImpl(double newHeading, double newVelocity) {
        this.heading = new StaticHeadingImpl(newHeading);
        this.velocity = new StaticVelocityImpl(newVelocity);
    }

    public StaticVectorImpl(StaticVector other) {
        this.heading = new StaticHeadingImpl(other);
        this.velocity = new StaticVelocityImpl(other);
    }

    public StaticVector compareVector(StaticVector other) {
        return new StaticVectorImpl(this.heading.getRelativeAngle(other), this.velocity.getRelativeVelocity(other));
    }

    public boolean equalsVector(StaticVector other) {
        return this.heading.equalsAngle(other) && this.velocity.equalsVelocity(other);
    }

    public void debug() {
        Debug.debug("Static Vector: ( " + this.heading.getHeading() + ", " + this.velocity.getVelocity() + " )");
    }

    public double getHeading() {
        return this.heading.getHeading();
    }

    public boolean equalsAngle(double other) {
        return this.heading.equalsAngle(other);
    }

    public boolean equalsAngle(StaticHeading other) {
        return this.heading.equalsAngle(other);
    }

    public double getRelativeAngle(double other) {
        return this.heading.getRelativeAngle(other);
    }

    public double getRelativeAngle(StaticHeading other) {
        return this.heading.getRelativeAngle(other);
    }

    public double getCompoundAngle(double other) {
        return this.heading.getCompoundAngle(other);
    }

    public double getCompoundAngle(StaticHeading other) {
        return this.heading.getCompoundAngle(other);
    }

    public double getVelocity() {
        return this.velocity.getVelocity();
    }

    public boolean equalsVelocity(double other) {
        return this.velocity.equalsVelocity(other);
    }

    public boolean equalsVelocity(StaticVelocity other) {
        return this.velocity.equalsVelocity(other);
    }

    public double getRelativeVelocity(double other) {
        return this.velocity.getRelativeVelocity(other);
    }

    public double getRelativeVelocity(StaticVelocity other) {
        return this.velocity.getRelativeVelocity(other);
    }

    public double getCompoundVelocity(double other) {
        return this.velocity.getCompoundVelocity(other);
    }

    public double getCompoundVelocity(StaticVelocity other) {
        return this.velocity.getCompoundVelocity(other);
    }
}

