package element;

import robocode.*;
import robocode.util.*;
import java.awt.geom.*;
import java.util.ArrayList; 


public class Earth extends AdvancedRobot
{
	public Point2D.Double enemyLoc;
	public static double totalTime = 0;
	public final static double PI = Math.PI;
	public static double round = 0;
	public static int direction = 1;
	//segments
	public final static int MAX_DISTANCE = 1000;
	public final static int DISTANCE_INDEXES = MAX_DISTANCE / 100;
	public final static int NEAR_WALL = 5;
	public final static int VELOCITY_INDEXES = 5;
	public final static int ACCELERATION_INDEXES = 3;
	public final static int TIME_SLICES = 11;
	public final static int TIME_SINCE_ACCEL = 11;
	public double prevVelocity = 0;
	public double myPrevVelocity = 0;
	public int timeSinceAccel = 0;
	public int mTimeSinceAccel = 0;
	
	//basic gun variables
	public final static int BINS = 97;
	public final static int MIDDLE_BIN = (BINS - 1) / 2;
	public final static double MAX_ESC_ANGLE = Math.PI / 4.0;
	public final static double BIN_WIDTH = MAX_ESC_ANGLE / MIDDLE_BIN;

	public static double[][][][][][][] aimFactors = new double[DISTANCE_INDEXES][NEAR_WALL][ACCELERATION_INDEXES][VELOCITY_INDEXES][TIME_SLICES][TIME_SINCE_ACCEL][BINS];
	public double[][][] surferFactors = new double[DISTANCE_INDEXES][VELOCITY_INDEXES][BINS];
	public static double[] hits = new double[2]; 
	public static double[] angles = new double[2]; 
	
   
	public static double[][][][][][] _surfStats = new double[DISTANCE_INDEXES][NEAR_WALL][ACCELERATION_INDEXES][VELOCITY_INDEXES][TIME_SINCE_ACCEL][BINS];
	public static double[] _surfStats2 = new double[BINS];
    public Point2D.Double _myLocation;    
    public Point2D.Double _enemyLocation; 

    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;

    public static double _oppEnergy = 100.0;

   
    public static Rectangle2D.Double _fieldRect = new java.awt.geom.Rectangle2D.Double(18, 18, 764, 564);
    public static double WALL_STICK = 160;

    public void run() {
        _enemyWaves = new ArrayList();
        _surfDirections = new ArrayList();
        _surfAbsBearings = new ArrayList();

        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);

        do {
            turnRadarRightRadians(Double.POSITIVE_INFINITY);
        } while (true);
    }

static final double FACTOR = 1.99;
	public void onScannedRobot(ScannedRobotEvent e) {
		double absBearing = e.getBearingRadians() + getHeadingRadians();
		//radar
    	setTurnRadarRightRadians( FACTOR*robocode.util.Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) );
		double firePower = e.getDistance() < 200 ? 3 : 1.72;
		if (e.getEnergy() < 16) {
			if (e.getEnergy() < 4)
				firePower = e.getEnergy()/4;
			else
				firePower = (e.getEnergy() + 2)/6;
		}
		//gf gun
		BulletWave w = new BulletWave();
		w.firedLocation = new Point2D.Double(getX(), getY());
		double enemyX = getX() + Math.sin(absBearing) * e.getDistance();
		double enemyY = getY() + Math.cos(absBearing) * e.getDistance();
		enemyLoc = new Point2D.Double(getX() + Math.sin(absBearing) * e.getDistance(), getY()
				+ Math.cos(absBearing) * e.getDistance());
		w.bearingDir = (e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing) < 0 ? -BIN_WIDTH
				: BIN_WIDTH);
		w.bearing = absBearing;
		w.velocity = bulletVelocity(firePower);
		int distanceIndex = (int) e.getDistance() / (MAX_DISTANCE / DISTANCE_INDEXES);
		int velocityIndex = (int) Math.abs(e.getVelocity() / 2);
		int wallIndex;
		int point = direction(e.getHeadingRadians());
		if (enemyX < 25 && point == 1){
			wallIndex = 1;
		}else if (enemyX > getBattleFieldWidth() - 25 && point == 3){
			wallIndex = 3;
		}else if (enemyY < 25 && point == 2){
			wallIndex = 2;
		}else if (enemyY > getBattleFieldHeight() - 25 && point == 4){
			wallIndex = 4;
		}else
			wallIndex = 0;
		int accelerationIndex;
		if (e.getVelocity() - prevVelocity == 0)
			accelerationIndex = 0; 
		else if (e.getVelocity() - prevVelocity > 0)
			accelerationIndex = 1;
		else
			accelerationIndex = 2;
		prevVelocity = e.getVelocity();
		int TIME_SLICE;
		if (getTime() < 1000)
			TIME_SLICE = (int) getTime() / 1000;
		else 
			TIME_SLICE = 10;
		timeSinceAccel++;
		if (e.getVelocity() != prevVelocity)
			timeSinceAccel = 0;
		int TIME_SINCE_ACCEL_INDEX = timeSinceAccel < 10 ? timeSinceAccel : 10;
		w.di = distanceIndex;
		w.wi = wallIndex;
		w.ai = accelerationIndex;
		w.vi = velocityIndex;
		w.ts = TIME_SLICE;
		w.tsai = TIME_SINCE_ACCEL_INDEX;
		int mostVisited = MIDDLE_BIN;
		for (int i = 0; i < BINS; i++)
			if (aimFactors[distanceIndex][wallIndex][accelerationIndex][velocityIndex][TIME_SLICE][TIME_SINCE_ACCEL_INDEX][i] > 
			aimFactors[distanceIndex][wallIndex][accelerationIndex][velocityIndex][TIME_SLICE][TIME_SINCE_ACCEL_INDEX][mostVisited])
				mostVisited = i;
		w.bin0 = mostVisited;
		angles[0]=(Utils.normalRelativeAngle(absBearing + w.bearingDir * (mostVisited - MIDDLE_BIN)));
		for (int i = 0; i < BINS; i++)
			if (surferFactors[distanceIndex][velocityIndex][i] > surferFactors[distanceIndex][velocityIndex][mostVisited])
				mostVisited = i;
		w.bin1 = mostVisited;
		angles[1]=(Utils.normalRelativeAngle(absBearing  + w.bearingDir * (mostVisited - MIDDLE_BIN)));
		if (hits[1] > hits[0])
			setTurnGunRightRadians(Utils.normalRelativeAngle(angles[1]- getGunHeadingRadians()));
		else
			setTurnGunRightRadians(Utils.normalRelativeAngle(angles[0]- getGunHeadingRadians()));
		if (setFireBullet(firePower) != null)
			addCustomEvent(w);
		//movement
		_myLocation = new Point2D.Double(getX(), getY());

        double lateralVelocity = getVelocity()*Math.sin(e.getBearingRadians());

        _surfDirections.add(0,
            new Integer((lateralVelocity >= 0) ? 1 : -1));
        _surfAbsBearings.add(0, new Double(absBearing + Math.PI));


        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09
            && _surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = getTime() - 1;
            ew.bulletVelocity = bulletVelocity(bulletPower);
            ew.distanceTraveled = bulletVelocity(bulletPower);
            ew.direction = ((Integer)_surfDirections.get(2)).intValue();
            ew.directAngle = ((Double)_surfAbsBearings.get(2)).doubleValue();
            ew.fireLocation = (Point2D.Double)_enemyLocation.clone();
			ew.distance = distanceIndex;
			ew.velocity = (int) Math.abs(getVelocity() / 2);
			int mWallIndex;
			if (getX() < 25 && point == 1){
				mWallIndex = 1;
			}else if (getX() > getBattleFieldWidth() - 25 && point == 3){
				mWallIndex = 3;
			}else if (getY() < 25 && point == 2){
				mWallIndex = 2;
			}else if (getY() > getBattleFieldHeight() - 25 && point == 4){
				mWallIndex = 4;
			}else
				mWallIndex = 0;
			ew.wall = mWallIndex;
			int mAccelerationIndex;
			if (getVelocity() - myPrevVelocity == 0)
				mAccelerationIndex = 0; 
			else if (getVelocity() - myPrevVelocity > 0)
				mAccelerationIndex = 1;
			else
				mAccelerationIndex = 2;
			mTimeSinceAccel++;
			if (getVelocity() != myPrevVelocity)
				mTimeSinceAccel = 0;
			myPrevVelocity = e.getVelocity();
			TIME_SINCE_ACCEL_INDEX = mTimeSinceAccel < 10 ? mTimeSinceAccel : 10;
        	ew.accelleration = mAccelerationIndex;
        	ew.timeSinceAccel = TIME_SINCE_ACCEL_INDEX;

            _enemyWaves.add(ew);
        }

        _oppEnergy = e.getEnergy();

        _enemyLocation = project(_myLocation, absBearing, e.getDistance());

        updateWaves();
        doSurfing(e);
		//other code
	}
	//methods
	
	public double checkDanger(EnemyWave surfWave, int direction,ScannedRobotEvent e) {
        int index = getFactorIndex(surfWave,
            predictPosition(surfWave, direction));
		
		//[DISTANCE_INDEXES][NEAR_WALL][ACCELERATION_INDEXES][VELOCITY_INDEXES][TIME_SINCE_ACCEL][BINS];
        return _surfStats[surfWave.distance][surfWave.wall][surfWave.accelleration][surfWave.velocity][surfWave.timeSinceAccel][index] + _surfStats2[index];
    }

    public void doSurfing(ScannedRobotEvent e) {
        EnemyWave surfWave = getClosestSurfableWave();

        if (surfWave == null) { return; }

        double dangerLeft = checkDanger(surfWave, -1,e);
        double dangerRight = checkDanger(surfWave, 1,e);

        double goAngle = absoluteBearing(surfWave.fireLocation, _myLocation);
        if (dangerLeft < dangerRight) {
            goAngle = wallSmoothing(_myLocation, goAngle - (Math.PI/2), -1);
        } else {
            goAngle = wallSmoothing(_myLocation, goAngle + (Math.PI/2), 1);
        }

        setBackAsFront(this, goAngle);
    }

	public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)_myLocation.clone();
        double predictedVelocity = getVelocity();
        double predictedHeading = getHeadingRadians();
        double maxTurning, moveAngle, moveDir;

        int counter = 0; // number of ticks in the future
        boolean intercepted = false;

        do {    // the rest of these code comments are rozu's
            moveAngle =
                wallSmoothing(predictedPosition, absoluteBearing(surfWave.fireLocation,
                predictedPosition) + (direction * (Math.PI/2)), direction)
                - predictedHeading;
            moveDir = 1;

            if(Math.cos(moveAngle) < 0) {
                moveAngle += Math.PI;
                moveDir = -1;
            }

            moveAngle = Utils.normalRelativeAngle(moveAngle);

            // maxTurning is built in like this, you can't turn more then this in one tick
            maxTurning = Math.PI/720d*(40d - 3d*Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle(predictedHeading
                + limit(-maxTurning, moveAngle, maxTurning));

            // this one is nice ;). if predictedVelocity and moveDir have
            // different signs you want to breack down
            // otherwise you want to accelerate (look at the factor "2")
            predictedVelocity += 
                (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir);
            predictedVelocity = limit(-8, predictedVelocity, 8);

            // calculate the new predicted position
            predictedPosition = project(predictedPosition, predictedHeading, 
                predictedVelocity);

            counter++;

            if (predictedPosition.distance(surfWave.fireLocation) <
                surfWave.distanceTraveled + (counter * surfWave.bulletVelocity)
                + surfWave.bulletVelocity) {
                intercepted = true;
            }
        } while(!intercepted && counter < 500);

        return predictedPosition;
    }

	public void onHitByBullet(HitByBulletEvent e) {
        // If the _enemyWaves collection is empty, we must have missed the
        // detection of this wave somehow.
        if (!_enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(
                e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;

            // look through the EnemyWaves, and find one that could've hit us.
            for (int x = 0; x < _enemyWaves.size(); x++) {
                EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

                if (Math.abs(ew.distanceTraveled -
                    _myLocation.distance(ew.fireLocation)) < 50
                    && Math.round(bulletVelocity(e.getBullet().getPower()) * 10)
                       == Math.round(ew.bulletVelocity * 10)) {
                    hitWave = ew;
                    break;
                }
            }

            if (hitWave != null) {
                logHit(hitWave, hitBulletLocation);

                // We can remove this wave now, of course.
                _enemyWaves.remove(_enemyWaves.lastIndexOf(hitWave));
            }
        }
	}
	public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = getFactorIndex(ew, targetLocation);

        for (int x = 0; x < BINS; x++) {
            // for the spot bin that we were hit on, add 1;
            // for the bins next to it, add 1 / 2;
            // the next one, add 1 / 5; and so on...
            
        _surfStats[ew.distance][ew.wall][ew.accelleration][ew.velocity][ew.timeSinceAccel][x] += rollingAvg(totalTime, 1.0 / (Math.pow(index - x, 2) + 1), 50000);
        _surfStats2[x] += rollingAvg(totalTime, 1.0 / (Math.pow(index - x, 2) + 1), 50000);
        }
    }

	public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = (absoluteBearing(ew.fireLocation, targetLocation)
            - ew.directAngle);
        double factor = Utils.normalRelativeAngle(offsetAngle)
            / maxEscapeAngle(ew.bulletVelocity) * ew.direction;

        return (int)limit(0,
            (factor * ((BINS - 1) / 2)) + ((BINS - 1) / 2),
            BINS - 1);
    }


	public EnemyWave getClosestSurfableWave() {
        double closestDistance = 5000; 
        EnemyWave surfWave = null;

        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
            double distance = _myLocation.distance(ew.fireLocation)
                - ew.distanceTraveled;

            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
        }

        return surfWave;
    }


	public void updateWaves() {
        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

            ew.distanceTraveled = (getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled >
                _myLocation.distance(ew.fireLocation) + 50) {
                _enemyWaves.remove(x);
                x--;
            }
        }
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(project(botLocation, angle, WALL_STICK))) {
            angle += orientation*0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, 
        double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
            sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return (20.0 - (3.0*power));
    }    
	public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0/velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle =
            Utils.normalRelativeAngle(goAngle - robot.getHeadingRadians());
        if (Math.abs(angle) > (Math.PI/2)) {
            if (angle < 0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100);
        } else {
            if (angle < 0) {
                robot.setTurnLeftRadians(-1*angle);
           } else {
                robot.setTurnRightRadians(angle);
           }
            robot.setAhead(100);
        }
    }


	int direction(double angle){
		if (angle > PI/4 && angle <= 3*PI){
			return 1;
		}else if (angle > 3*PI/4 && angle <= 5*PI){
			return 2;
		}else if (angle > 5*PI/4 && angle <= 7*PI){
			return 3;
		}else return 4;
	}

	
	static double rollingAvg(double time, double newEntry, double roll) {
    	return newEntry + time/(100*roll);
	}

	public void onDeath(DeathEvent event){
       totalTime = getTime();
	}

	public void onWin(WinEvent event){
       totalTime = getTime();
	}
	
	//internal classes
	class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity, directAngle, distanceTraveled;
        int direction;
        int distance;
        int velocity;
        int accelleration;
        int timeSinceAccel;
        int wall;

        public EnemyWave() { }
    }

	public class BulletWave extends Condition {
		Point2D.Double firedLocation;
		double velocity, distanceTraveled, bearing, bearingDir;
		int bin0,bin1;
		//[distanceIndex][wallIndex][accelerationIndex][velocityIndex][TIME_SLICE][TIME_SINCE_ACCEL_INDEX]
		int di,wi,ai,vi,ts,tsai;

		public boolean test() {
			distanceTraveled += velocity;
			double distance = firedLocation.distance(enemyLoc);
			if (distanceTraveled > distance - 18) {
				try {
					/*for (int x = 0; x < BINS; x++) {
            // for the spot bin that we were hit on, add 1;
            // for the bins next to it, add 1 / 2;
            // the next one, add 1 / 5; and so on...
            
        _surfStats[ew.distance][ew.wall][ew.accelleration][ew.velocity][ew.timeSinceAccel][x] += rollingAvg(totalTime, 1.0 / (Math.pow(index - x, 2) + 1), 50000);
        _surfStats2[x] += rollingAvg(totalTime, 1.0 / (Math.pow(index - x, 2) + 1), 50000);
        }*/
					int index = (int) (
							Utils.normalRelativeAngle(absoluteBearing(firedLocation, enemyLoc) - bearing) / bearingDir)+ MIDDLE_BIN;
					for (int x = 0; x < BINS;x++) {
						aimFactors[di][wi][ai][vi][ts][tsai][x] += rollingAvg(totalTime, 1.0 / (Math.pow(index - x, 2) + 1), 500);
						surferFactors[di][vi][x] += rollingAvg(totalTime, 1.0 / (Math.pow(index - x, 2) + 1), 50);
					}
				} catch (Exception e) {
				}
				if ((int) (((Utils.normalRelativeAngle(absoluteBearing(firedLocation, enemyLoc)) - bearing) / bearingDir) + MIDDLE_BIN) == bin0)
					hits[0]++;
				if ((int) (((Utils.normalRelativeAngle(absoluteBearing(firedLocation, enemyLoc)) - bearing) / bearingDir) + MIDDLE_BIN) == bin1)
					hits[1]++;
				removeCustomEvent(this);
			}
			return false;
		}
	}
}