package jeremyreeder.collective;

import java.util.*; import java.lang.*; import java.awt.*;
import robocode.*; import robocode.util.*;

/*
__________                      .__            __
\______   \_______  ____ ______ |  |__   _____/  |_
 |     ___/\_  __ \/  _ \\____ \|  |  \_/ __ \   __\
 |    |     |  | \(  <_> )  |_> >   Y  \  ___/|  |
 |____|     |__|   \____/|   __/|___|  /\___  >__|
                         |__|        \/     \/
*/
public class Prophet extends CollectiveRobot { /*
	A data-sharing, bullet-dodging robot by Jeremy Reeder, designed
	for 1v1 battles or for team play with other CollectiveRobots, such
	as Prophets and Disciples.
*/	protected int directionToggle = 1;
	protected double getOptimalFirePower(Bogey target) { // balance probability of hitting with benefit of hitting
		return Rules.MAX_BULLET_POWER; // haven't found a better way yet
	}
	protected boolean isTimeToFight = true;
	public void run() {
		setTurnRateRadians(Rules.MAX_TURN_RATE_RADIANS);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		while (true) {
			if (isTimeToFight) fight(); else pray();
			execute();
		}
	}
	protected void fight() {
		refreshData(); // detect Missiles, sort Projectiles, etc.
		// target the enemy
			Bogey target = aquireTarget();
			if (target == null) { // if no hostile Bogeys, search for more
				final double velocity = getVelocity();
				final double absoluteSpeed = Math.abs(velocity);
				setVelocityRate( // slow down if necessary to avoid wall damage
					nonZeroSign(velocity) * Math.min(absoluteSpeed, 1.999)
				);
				searchForBogeys();
			} else {
				setTurnRateRadians(0);
				scanTargetArea(target);
				final double optimalFirePower = getOptimalFirePower(target);
				final boolean isInMySights = aimAtTarget(target, optimalFirePower);
				if (isInMySights)
					setFire(optimalFirePower);
			}
		// dodge the most threatening missile by turning perpendicular to its path and accelerating until not on collision course
			Missile mostThreateningMissile = missileSet.first();
			if (mostThreateningMissile != null && mostThreateningMissile.willHitMe()) {
				final double myHeadingRadians = getHeadingRadians();
				final double missileHeadingRadians = mostThreateningMissile.getHeadingRadians();
				final double perpendicular1 = Utils.normalRelativeAngle(missileHeadingRadians - myHeadingRadians + Math.PI / 2);
				final double perpendicular2 = Utils.normalRelativeAngle(missileHeadingRadians - myHeadingRadians - Math.PI / 2);
				final double closestPerpendicular = (
					Math.abs(perpendicular1) < Math.abs(perpendicular2) ?
					perpendicular1 : perpendicular2
				);
				setTurnRateRadians(closestPerpendicular);
				double velocity = getVelocity();
				final double absoluteSpeed = Math.abs(velocity);
				if (absoluteSpeed < Rules.MAX_VELOCITY) {
					if (absoluteSpeed > 0)
						velocity = directionToggle * (absoluteSpeed + Rules.ACCELERATION);
					else {
						directionToggle = -directionToggle;
						velocity = directionToggle * Rules.ACCELERATION;
					}
				} else
					velocity = directionToggle * (absoluteSpeed - Rules.DECELERATION);
				setVelocityRate(velocity);
			} else if (target != null && target.isHostile()) { // if no missile threatens me, stalk target
				final double velocity = getVelocity();
				final double bearingToward = target.getBearingRadians();
				final double bearingAway = Utils.normalRelativeAngle(bearingToward + Math.PI);
				double acceleration, turnRateDivisor;
				if (target.isWithinRadarRange()) {
					acceleration = Rules.ACCELERATION / 14; // no sudden movements
					turnRateDivisor = 180; // turn slowly
				} else {
					acceleration = Rules.ACCELERATION; // approach target quickly
					turnRateDivisor = 4.5;
				}
				if (Math.abs(bearingToward) < Math.abs(bearingAway)) {
					setTurnRateRadians(bearingToward / turnRateDivisor); // turn toward target
					setVelocityRate(getVelocity() + acceleration); // accelerate forward
				} else {
					setTurnRateRadians(bearingAway / turnRateDivisor); // turn away from target
					setVelocityRate(getVelocity() - acceleration); // accelerate backward
				}
			}
	}
	protected void pray() {
		final double east = Math.PI / 2;
		setVelocityRate(getVelocity() / 2); // come to a gradual stop
		setTurnRateRadians( // gradually face east
			Utils.normalRelativeAngle(east - getHeadingRadians()) / 2
		);
		setGunRotationRateRadians( // gradually point east
			Utils.normalRelativeAngle(east - getGunHeadingRadians()) / 2
		);
		setRadarRotationRateRadians( // gradually look east
			Utils.normalRelativeAngle(east - getRadarHeadingRadians()) / 2
		);
	}
	public void onWin(WinEvent e) { isTimeToFight = false; }
	public void onHitWall(HitWallEvent e) { directionToggle = -directionToggle; }
	public void onHitRobot(HitRobotEvent e) {
		super.onHitRobot(e);
		directionToggle = -directionToggle;
	}
}

