/*
 * Created on May 28, 2003
 *
 * Currently a test nano
 */

package jep.nano;
import robocode.*;

/**
 * @author johnp
 *
 * Experiment in the nanobot world.
 */
public class Hotspur extends AdvancedRobot {
	
	private int direction = -1;
	private long lastTime = -20;
	private double lastBearing = 0.0;
	
	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		while (true) {
			if (getOthers() > 0.0) {
				setFire(3.0);
			}
			long i = getTime();
			if (i - lastTime > 16) {
				setTurnRadarRightRadians(3.0*Math.PI);
			}
			execute();
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double bearingPlusHeading = (lastBearing = e.getBearingRadians()) + getHeadingRadians();
		lastTime = getTime();
		setTurnGunRightRadians(normalRelativeAngleRadians(bearingPlusHeading - getGunHeadingRadians()));
		setTurnRadarRightRadians(3.0*Math.sin(bearingPlusHeading - getRadarHeadingRadians()));
		setTurnRightRadians(e.getBearingRadians() + 3.0*Math.PI/4.0 - Math.random()*Math.PI/2.0);
		setAhead(200.0*direction);
	}
	
	public void onHitWall(HitWallEvent e) {
		setTurnRightRadians(Math.PI/2.0 - e.getBearingRadians());
		setAhead(200.0*(direction *= -1));
	}
	
	public static double normalRelativeAngleRadians(double angle) {
		return ((angle + 7*Math.PI) % (2*Math.PI)) - Math.PI;
	}
	
}
