/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package robar.nano;
import java.util.Random;

import robocode.*;
import robocode.util.*;
/**
 *
 * Pugio 1.0 - First release with LT/RT gun, beta Adapting Oscillator Movement
 * 
 * Pugio 1.1 - several codesize reductions, deleted wall-avoiding, corrected fire power-management,
 *             added distance-management
 * 
 * Pugio 1.2 - without colours, deleted fire power management and frequency resetting, added a nice symbolic pattern matcher gun :)
 *              Pugio 1.2 vs 1.1 - 5000:1000 ;)
 *              
 * Pugio 1.3 - WeekendObsession's gun with rounding, new, much smaller distance-controlling, more aggressive approaching, 2.5 firepower, the movement
 * 				now reacts to enemy fire. Pugio 1.3 vs Pugio 1.2 : 65%/35% ;) 13th May 2009  
 * 
 * Pugio 1.4 - No setAdjustGun, slower frequency adjusting due to codesize demands. Velocity trick added which is strengthened by dies. Big improvement against
 * 				pattern matchers, a bit less effective against HOT.
 * 
 * Pugio 1.45 - Fixed velocity-trick; faster frequency adjusting. Even better against pattern matchers and HOT. :) 247 bytes 17th May 2009
 * 
 * Pugio 1.46 - Tweaked velocity-trick. 249 bytes 17th May 2009
 * 
 * Pugio 1.47 - Corrected distancing and reduced preferred distance to 180. 249 bytes, 12th June 2009
 * 
 * Pugio 1.49 - Fixed the bug in the beginning of the battles plus adjusted velocity trick a bit. 249 bytes, 30th July 2009
 */
public class Pugio extends AdvancedRobot{

    //Global variables
    static double frequency;
    static double prevEnergy;
    static String enemyLog = "" + (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0
    + (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0
    + (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0 + (char)8 + (char)8+ (char)8+ (char)8+ (char)8+ (char)8
    + (char)8+ (char)8+ (char)-8+ (char)-8+ (char)-8+ (char)-8+ (char)-8+ (char)-8+ (char)-8+ (char)-8+ (char)-8
    + (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0
    + (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0
    + (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0+ (char)0 + (char)8 + (char)8+ (char)8+ (char)8+ (char)8+ (char)8
    + (char)8+ (char)8+ (char)-8+ (char)-8+ (char)-8+ (char)-8+ (char)-8+ (char)-8+ (char)-8+ (char)-8+ (char)-8;;
    
    static final double FIREPOWER = 2.5;
    static final double BULLETVEL = 20-3*FIREPOWER;
    static final double PREFDIST = 180.0;
    static final int PATTERN_DEPTH = 30;

    //static final int DEATHLIMIT = 1; //Do StopNGo until 2 death
    //static int rFactor; //Random factor
    
    
    //main loop
    public void run(){
        //setAdjustGunForRobotTurn(true);
        //some ancient roman dagger-look painting :)
      //  setColors(Color.gray, Color.orange.darker(), Color.orange);
        //infinity-lock
        setTurnRadarRight(Double.POSITIVE_INFINITY);

    }
    //here comes the fun stuff
    public void onScannedRobot(ScannedRobotEvent e){
    	
    	//Note that the order is important! The first variables have to be the most used. You can save 3-4 bytes with this trick! 
    	//Local variables 
		int matchLenght = PATTERN_DEPTH; //the number of data a pattern contains, then the counter in the absB updater loop  		
		double absB; //absolute bearing 		
		int i; 	 		    		
		int index; //index of the match of the pm gun
		double dist; //Saves codesize
		
       // double firePower = 3.0-e.getDistance()/333.33; //distance-dependent firePower //333 is (800x600's cross)/3

        //if I died too many times, this movement may don't work, so I switch back
        //if(frequency==35)frequency=5;
        //simple oscillator movement with resizeable frequency
		if(prevEnergy>(prevEnergy = e.getEnergy())){
			setAhead(Math.sin(getTime()/(5+frequency))*500);
			setMaxVelocity(14-frequency*Math.random());
		}
        //setAhead(Math.sin(getTime()/frequency)*100);
       //setTurnRightRadians( (absB = e.getBearingRadians())+ 1.57 + Math.signum(getVelocity())*(e.getDistance()<200.0?0.17:-0.17));
        setTurnRightRadians(Math.cos(absB = e.getBearingRadians())- Math.signum(getVelocity() * ((dist=e.getDistance()) - PREFDIST)) *0.17);
        //setTurnRightRadians(Math.cos(absB=e.getBearingRadians()));
        //setMaxVelocity(Math.random()*12+4);
        
        
      //Inserting the newest lateral velocity into the beginning of our log
        enemyLog = String.valueOf( (char)(e.getVelocity() * Math.sin(e.getHeadingRadians() - ( absB += getHeadingRadians() )))).concat(enemyLog);

        //Reducing pattern depth until find a match. Store the index of the match.
        while((index = enemyLog.indexOf(enemyLog.substring(0, matchLenght--), (i = (int)(( dist )/BULLETVEL)))) < 0);

        //Add the angular velocities of the first bullet flight time lateral velocities to absolute bearing.  
        do{
            absB += Math.asin(((byte)enemyLog.charAt(index--))/ dist );
        }while(--i > 0);

        //Turning gun to head the predicted absolute bearing
        setTurnGunRightRadians(Utils.normalRelativeAngle(absB-getGunHeadingRadians()));
        
        //Fire in the hall!
        setFire(FIREPOWER);

        
        setTurnRadarLeft(getRadarTurnRemaining());
    }
    

    public void onDeath(DeathEvent e){
        frequency ++;
    }

}




