package bp;
import robocode.*;
import java.awt.Color;

/**
 * Kuma - a robot by (Ninjabjrn)
 */
public class Kuma extends AdvancedRobot
{
	
	private Enemy enemy;        

	private byte radarDirection = 1;
	private byte moveDirection = 1;
	
	/**
	 * run: Kuma's default behavior
	 */
	public void run() {
    	enemy = new Enemy();             
    	setColors(new Color(66,33,00),Color.BLACK,Color.WHITE);

		setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
     
	   turnRadarRightRadians(2*Math.PI);     

		while(true) {
			scan();
			move();
			gun();
			execute();
		}
	}

	public void onRobotDeath(RobotDeathEvent e) {
		if (e.getName().equals(enemy.getName())) {
			enemy.reset();
		}
	}

	public void scan (){
		if(enemy.none()){
			setTurnRadarRight(360);
		}else{
			double turn = getHeading() - getRadarHeading() + enemy.getBearing();
			turn += 30 * radarDirection;
			setTurnRadarRight(normalizeBearing(turn));
			radarDirection *= -1;
		}
	}
	
	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		setTurnGunRight(getHeading() - getGunHeading() + e.getBearing());
		if (enemy.none() || e.getDistance() < enemy.getDistance() - 70 ||e.getName().equals(enemy.getName())) {
			enemy.update(e);
		}
     }	

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		//turnLeft(90 - e.getBearing());
		moveDirection *= -1;
	}

	
	public void onHitWall(HitWallEvent e) {
		moveDirection *= -1;
	}


	
	
	public void move(){
		
	
		setTurnRight(normalizeBearing(enemy.getBearing() + 90 - (15 * moveDirection)));

	    if (getTime() % 20 == 0) {
			//moveDirection *= -1;
			setAhead(150 * moveDirection);
		}
		
	}

	public void gun(){
		

		if (enemy.none()) return;

			if (getGunHeat() == 0 && Math.abs(getGunTurnRemaining()) < 10)
				setFire(Math.min(400 / enemy.getDistance(), 3));


			double turn = getHeading() - getGunHeading() + enemy.getBearing();
			setTurnGunRight(normalizeBearing(turn));
	}

	double normalizeBearing(double angle) {
		while (angle >  180) angle -= 360;
		while (angle < -180) angle += 360;
		return angle;
	}

class Enemy{
    private String name;
    private double bearing;
	private double energy;
    private double heading;
    private long ctime;
    private double speed;
    private double x,y;
    private double distance;

	public Enemy(){
		reset();
	}
	
	public double getBearing(){
	     return bearing;
	}
	public double getHeading(){
	     return heading;
	}
	public double getSpeed(){
	     return speed;
	}
	public double getDistance(){
	     return distance;
	}
	public double getEnergy(){
		return energy;
	}
	public String getName(){
		return name;	
	}
		
	public void reset(){
		name = "";
		bearing = 0;
		energy = 0;
		heading=0;
		ctime=0;
		speed=0;
		x=0;
		y=0;
		distance = 0;	
	}
	
	public boolean none(){
		return name.equals("");
	}

	public void update(ScannedRobotEvent e){
		name = e.getName();
		bearing = e.getBearing();
		heading = e.getHeading();
		ctime = System.currentTimeMillis();
		speed = e.getVelocity();
		distance = e.getDistance();
		energy = e.getEnergy();
	}
	
    public double guessX(long when)

    {

        long diff = when - ctime;

        return x+Math.sin(heading)*speed*diff; 

    }

    public double guessY(long when)

    {

        long diff = when - ctime;

        return y+Math.cos(heading)*speed*diff;

    }

}
}
