package mld;
import robocode.*;
import java.awt.Color;
import robocode.util.Utils;

//  Wisdom - a robot by Michael Dorgan

// --------------------------------------------------------------------------------------------------------------------------------------------
// Revision 5-29-09 ver 1.0
//
// Decided to make an aggressive melee bot from my built up wisdom.  We'll see how far I can take it.
//
// --------------------------------------------------------------------------------------------------------------------------------------------

public class Wisdom extends AdvancedRobot
{
  // tunable constants
  // for movement
  private final static double MOVE_DISTANCE       = 40;//160;
  private final static double PREFERRED_RANGE     = 100.0;
  private final static double CLOSE_FCT           = 450 * MOVE_DISTANCE;
  
  // attributes
  // for movement
  private static double       enemyEnergy;
  private static double       moveDir             = MOVE_DISTANCE;

  /**
   * Bot run method.
   */
 	public void run() 
	{
    	// helps targeting accuracy
    	setAdjustGunForRobotTurn(true);

    	// start our infinite radar loop
    	while(true)turnRadarRightRadians(Double.POSITIVE_INFINITY);
  	}
  
	static double averageBearing;
  	/**
  	* Scan handler.
   	* This is where it all happens.
   	*/ 
  	public void onScannedRobot(ScannedRobotEvent e) 
	{
    	// register vars, should be the most commonly used
    	double rd = e.getBearingRadians();

		setAhead(moveDir);// * (Math.random() + NON_RAND));
		
	    	// turn perpendicular with range control
    	if (e.getDistance() < 1000.0D / Math.sqrt(getOthers())) 
		{
			boolean energyTest = Math.abs((enemyEnergy - (enemyEnergy = e.getEnergy()) - 2)) < 2;
			if(energyTest && e.getDistance() < 300)
				moveDir = -moveDir;
			
										
	    	setTurnRightRadians(Math.cos(rd - (e.getDistance() - PREFERRED_RANGE) * moveDir / CLOSE_FCT));
    
	    	// rd has enemy relative bearing
    		rd += getHeadingRadians();
			setTurnRadarRightRadians(5 * Math.sin(rd - getRadarHeadingRadians()));
		
    		// turn gun
			setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(rd - getGunHeadingRadians() + 
				Math.max((1 - e.getDistance() / (500+100)),0) * 
				Math.asin(e.getVelocity() / 11) * Math.sin(e.getHeadingRadians() - rd) ));					
				
			setFire(30 * getEnergy() / e.getDistance());
			
			clearAllEvents();
		}
	}
  
  	/**
   	* Hit a wall, reverse direction and start moving immediately.
   	*/
  	public void onHitWall(HitWallEvent e) 
	{
    	setAhead(moveDir = -moveDir);
  	}
}

